/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.events;

import org.bukkit.command.CommandSender;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsGlobalBonus;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public class CommandEventStop
extends SkillsCommand {
    public CommandEventStop(SkillsCommand skillsCommand) {
        super("stop", skillsCommand, SkillsLang.COMMAND_EVENT_STOP_DESCRIPTION, false, new String[0]);
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (stringArray.length == 0) {
            SkillsCommandHandler.sendUsage(commandSender, "<xp/soul>");
            return;
        }
        SkillsEventType skillsEventType = SkillsEventType.fromString(stringArray[0]);
        if (skillsEventType == null) {
            SkillsLang.COMMAND_EVENT_NOT_FOUND.sendMessage(commandSender, "%event%", stringArray[0]);
            return;
        }
        SkillsGlobalBonus skillsGlobalBonus = SkillsEventManager.getEvent(skillsEventType);
        if (skillsGlobalBonus == null) {
            SkillsLang.EVENT_NOT_RUNNING.sendMessage(commandSender, new Object[]{"%event%", skillsEventType});
            return;
        }
        ((SkillsBonus)skillsGlobalBonus).stop();
        SkillsLang.COMMAND_EVENT_STOP_SUCCESS.sendPlayersMessage(new Object[]{"%player%", commandSender.getName(), "%event%", skillsEventType});
    }

    @Override
    public @Nullable String[] tabComplete(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        return new String[]{"XP", "Soul"};
    }
}

