/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.events;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.events.SkillsBonus;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsGlobalBonus;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandEventStart
extends SkillsCommand {
    public CommandEventStart(SkillsCommand skillsCommand) {
        super("start", skillsCommand, SkillsLang.COMMAND_EVENT_START_DESCRIPTION, false, new String[0]);
    }

    @Override
    public void runCommand(@NonNull CommandSender commandSender, @NonNull String[] stringArray) {
        if (stringArray.length >= 3) {
            double d;
            SkillsEventType skillsEventType = SkillsEventType.fromString(stringArray[0]);
            if (skillsEventType == null) {
                SkillsCommandHandler.sendUsage(commandSender, "<exp/soul> <time in mins> <multiplier>");
                return;
            }
            Long l = MathUtils.calcMillis(stringArray[1], TimeUnit.SECONDS);
            if (l == null) {
                SkillsCommandHandler.sendUsage(commandSender, "<exp/soul> <time> <multiplier>");
                return;
            }
            try {
                d = Double.parseDouble(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                SkillsCommandHandler.sendUsage(commandSender, "<xp/soul> <time> <multiplier>");
                return;
            }
            SkillsGlobalBonus skillsGlobalBonus = SkillsEventManager.getEvent(skillsEventType);
            if (skillsGlobalBonus == null || !skillsGlobalBonus.isActive()) {
                skillsGlobalBonus = new SkillsGlobalBonus(skillsEventType, String.valueOf(d), Duration.ofMillis(l), System.currentTimeMillis());
                ((SkillsBonus)skillsGlobalBonus).start();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkillsLang.COMMAND_BOOST_BROADCAST.sendMessage(player, "%type%", skillsEventType.toString(), "%multiplier%", String.valueOf(d), "%time%", skillsGlobalBonus.getDisplayDuration());
                }
            } else {
                SkillsLang.COMMAND_BOOST_ALREADY_STARTED.sendMessage(commandSender, "%type%", skillsEventType.toString(), "%multiplier%", d, "%time%", skillsGlobalBonus.getDisplayDuration());
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "<xp/soul> <time> <multiplier>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return new String[]{"Soul", "XP"};
        }
        String[] stringArray2 = new String[]{"<time>", "<multiplier>"};
        return TabCompleteManager.descendingSuggestions(stringArray2, (String[])Arrays.stream(stringArray).skip(1L).toArray(String[]::new));
    }
}

