/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands.bonuses;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEventType;
import org.skills.events.SkillsPersonalBonus;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathEval;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class CommandBonusGive
extends SkillsCommand {
    public CommandBonusGive(SkillsCommand skillsCommand) {
        super("give", skillsCommand, SkillsLang.COMMAND_BONUS_GIVE_DESCRIPTION, "start");
    }

    @Override
    public void runCommand(@NotNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 4) {
            try {
                OfflinePlayer offlinePlayer = this.getPlayer(commandSender, stringArray[0]);
                if (offlinePlayer == null) {
                    return;
                }
                SkillsEventType skillsEventType = SkillsEventType.fromString(stringArray[1]);
                if (skillsEventType == null) {
                    SkillsLang.COMMAND_BONUS_NOT_FOUND.sendMessage(commandSender, "%bonus%", stringArray[1]);
                    return;
                }
                Long l = MathUtils.calcMillis(stringArray[2], TimeUnit.SECONDS);
                if (l == null) {
                    SkillsLang.INVALID_TIME.sendMessage(commandSender, new Object[0]);
                    return;
                }
                String string = stringArray[3];
                if (string.contains("xp") && skillsEventType != SkillsEventType.XP || string.contains("soul") && skillsEventType != SkillsEventType.SOUL) {
                    SkillsLang.COMMAND_BONUS_GIVE_MULTIPLIER_ERROR.sendMessage(commandSender, new Object[0]);
                    return;
                }
                try {
                    MathEval.evaluate(string.replace("xp", "1").replace("soul", "1"));
                }
                catch (Throwable throwable) {
                    SkillsLang.COMMAND_BONUS_GIVE_MULTIPLIER_INVALID.sendMessage(commandSender, new Object[0]);
                    return;
                }
                SkillsPersonalBonus skillsPersonalBonus = new SkillsPersonalBonus(offlinePlayer.getUniqueId(), skillsEventType, string, Duration.ofMillis(l), System.currentTimeMillis());
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
                skilledPlayer.addBonus(skillsPersonalBonus);
                skillsPersonalBonus.start();
                SkillsLang.COMMAND_BONUS_GIVE_CONFIRMATION.sendMessage(commandSender, "%player%", offlinePlayer.getName(), "%time%", stringArray[2]);
                if (offlinePlayer.isOnline()) {
                    Player player = offlinePlayer.getPlayer();
                    SkillsLang.COMMAND_BONUS_GIVE_SUCCESS.sendMessage(player, "%time%", stringArray[2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                SkillsCommandHandler.sendUsage(commandSender, "<player> <xp/soul> <time> <multiplier>");
            }
        } else {
            SkillsCommandHandler.sendUsage(commandSender, "<player> <xp/soul> <time> <multiplier>");
        }
    }

    @Override
    public String[] tabComplete(@NonNull CommandSender commandSender, @NotNull String[] stringArray) {
        if (stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return new String[]{"soul", "XP"};
        }
        String[] stringArray2 = new String[]{"<time>", "<multiplier>"};
        return TabCompleteManager.descendingSuggestions(stringArray2, (String[])Arrays.stream(stringArray).skip(2L).toArray(String[]::new));
    }
}

