/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.Nullable;
import org.skills.commands.SkillsCommand;
import org.skills.commands.SkillsCommandHandler;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;
import org.skills.types.SkillManager;
import org.skills.utils.StringUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public final class TabCompleteManager
implements TabCompleter {
    protected static @NonNull List<String> getSuggestions(CommandSender commandSender, @Nullable String string) {
        return SkillsCommandHandler.getCommands().stream().filter(skillsCommand -> skillsCommand.getGroup() == null && skillsCommand.hasPermission(commandSender)).map(SkillsCommand::getName).filter(string2 -> string2.startsWith(string.toLowerCase())).collect(Collectors.toList());
    }

    public static @NonNull List<String> getSubCommand(CommandSender commandSender, @NonNull SkillsCommand skillsCommand2, @NonNull String[] stringArray) {
        String string = stringArray[0];
        SkillsCommand[] skillsCommandArray = skillsCommand2.getSubCommands();
        if (skillsCommandArray.length == 0) {
            return new ArrayList<String>();
        }
        Stream<String> stream = Arrays.stream(skillsCommandArray).filter(skillsCommand -> skillsCommand.hasPermission(commandSender)).map(SkillsCommand::getName);
        if (string.isEmpty()) {
            return stream.collect(Collectors.toList());
        }
        return stream.filter(string2 -> string2.startsWith(string.toLowerCase())).collect(Collectors.toList());
    }

    public static String[] getMasteries(String string) {
        return Strings.isNullOrEmpty((String)string) ? (String[])MasteryManager.getMasteries().stream().map(Mastery::getName).toArray(String[]::new) : (String[])MasteryManager.getMasteries().stream().map(Mastery::getName).filter(string2 -> string2.toLowerCase().startsWith(string.toLowerCase())).toArray(String[]::new);
    }

    public static List<String> getSkillTypes(String string) {
        return Strings.isNullOrEmpty((String)string) ? SkillManager.getSkills().keySet().stream().map(StringUtils::capitalize).collect(Collectors.toList()) : SkillManager.getSkills().keySet().stream().filter(string2 -> string2.startsWith(string.toLowerCase())).map(StringUtils::capitalize).collect(Collectors.toList());
    }

    public static @NonNull String[] descendingSuggestions(@NonNull String[] stringArray, @NonNull String[] stringArray2) {
        if (stringArray2.length - 1 == -1) {
            return stringArray;
        }
        int n = stringArray2.length - 1;
        Object[] objectArray = (String[])Arrays.stream(stringArray).skip(n).toArray(String[]::new);
        if (objectArray.length == 0) {
            return new String[0];
        }
        String string = Arrays.toString(objectArray);
        string = string.substring(1, string.length() - 1);
        return new String[]{string};
    }

    public static String[] getSuggestions(String[] stringArray, String string) {
        return Strings.isNullOrEmpty((String)string) ? stringArray : (String[])Arrays.stream(stringArray).filter(string2 -> string2.startsWith(string)).toArray(String[]::new);
    }

    private @NonNull List<String> getPlayers(@Nullable String string) {
        Stream<String> stream = Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName);
        return Strings.isNullOrEmpty((String)string) ? stream.collect(Collectors.toList()) : stream.filter(string2 -> string2.toLowerCase().startsWith(string.toLowerCase())).collect(Collectors.toList());
    }

    @Nullable
    public List<String> onTabComplete(@NonNull CommandSender commandSender, @NonNull Command command, @NonNull String string, @NonNull String[] stringArray) {
        if (stringArray.length == 1) {
            return TabCompleteManager.getSuggestions(commandSender, stringArray[0]);
        }
        SkillsCommandHandler.Pair<SkillsCommand, Integer> pair = SkillsCommandHandler.getLastCommand(stringArray);
        SkillsCommand skillsCommand = pair.getKey();
        if (skillsCommand == null) {
            return new ArrayList<String>();
        }
        int n = pair.getValue();
        if (!skillsCommand.hasPermission(commandSender)) {
            return new ArrayList<String>();
        }
        String[] stringArray2 = (String[])Arrays.stream(stringArray).skip(n + 1).toArray(String[]::new);
        if (skillsCommand.isGroup() && stringArray.length == n) {
            return TabCompleteManager.getSubCommand(commandSender, skillsCommand, stringArray2);
        }
        String[] stringArray3 = skillsCommand.tabComplete(commandSender, stringArray2);
        if (stringArray3 == null) {
            if (stringArray2.length != 0) {
                return this.getPlayers(stringArray2[0]);
            }
            return this.getPlayers(null);
        }
        return Arrays.asList(stringArray3);
    }
}

