/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.skills.commands.SkillsCommand;
import org.skills.commands.bonuses.CommandBonus;
import org.skills.commands.events.CommandEvent;
import org.skills.commands.friends.CommandFriend;
import org.skills.commands.friends.CommandFriendAccept;
import org.skills.commands.friends.CommandFriendTeleport;
import org.skills.commands.friends.CommandFriends;
import org.skills.commands.friends.CommandUnfriend;
import org.skills.commands.general.CommandAbout;
import org.skills.commands.general.CommandActionBar;
import org.skills.commands.general.CommandCosmetic;
import org.skills.commands.general.CommandDebug;
import org.skills.commands.general.CommandHPScaling;
import org.skills.commands.general.CommandHelp;
import org.skills.commands.general.CommandImprove;
import org.skills.commands.general.CommandInfo;
import org.skills.commands.general.CommandKeyBinding;
import org.skills.commands.general.CommandMastery;
import org.skills.commands.general.CommandMusic;
import org.skills.commands.general.CommandRefresh;
import org.skills.commands.general.CommandReload;
import org.skills.commands.general.CommandSelect;
import org.skills.commands.general.CommandShop;
import org.skills.commands.general.CommandShowActiveMessages;
import org.skills.commands.general.CommandSouls;
import org.skills.commands.general.CommandSound;
import org.skills.commands.general.CommandStatistics;
import org.skills.commands.general.CommandStats;
import org.skills.commands.general.CommandTest;
import org.skills.commands.general.CommandTop;
import org.skills.commands.general.CommandUpdates;
import org.skills.commands.party.CommandParty;
import org.skills.commands.user.CommandUser;
import org.skills.data.managers.CosmeticCategory;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.StringUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.xseries.XSound;

public class SkillsCommandHandler
implements CommandExecutor {
    protected static final List<SkillsCommand> commands = new ArrayList<SkillsCommand>();
    private final SkillsPro plugin;

    public SkillsCommandHandler(SkillsPro skillsPro) {
        this.plugin = skillsPro;
        commands.clear();
        new CommandHelp();
        new CommandUser();
        new CommandUpdates();
        new CommandAbout();
        new CommandDebug();
        new CommandSelect();
        new CommandInfo();
        new CommandTop();
        new CommandHPScaling();
        new CommandStatistics();
        new CommandSound();
        new CommandTest();
        new CommandStats();
        new CommandShowActiveMessages();
        new CommandActionBar();
        new CommandReload();
        new CommandRefresh();
        new CommandMastery();
        new CommandImprove();
        new CommandKeyBinding();
        new CommandBonus();
        new CommandEvent();
        new CommandSouls();
        new CommandShop();
        new CommandMusic();
        new CommandParty();
        new CommandFriends();
        new CommandFriendTeleport();
        new CommandFriendAccept();
        new CommandFriend();
        new CommandUnfriend();
        for (CosmeticCategory cosmeticCategory : CosmeticCategory.getCategories().values()) {
            new CommandCosmetic(cosmeticCategory);
        }
    }

    public static List<SkillsCommand> getCommands() {
        return commands;
    }

    public static SkillsCommand getSmartCommand(String[] stringArray, int n) {
        String[] stringArray2 = Arrays.copyOfRange(stringArray, n - 2, stringArray.length);
        return SkillsCommandHandler.getCommand(stringArray[n - 1], stringArray2);
    }

    public static SkillsCommand getCommand(String string, String ... stringArray) {
        if (stringArray.length == 0) {
            return commands.stream().filter(skillsCommand -> skillsCommand.getGroup() == null && skillsCommand.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
        }
        SkillsCommand skillsCommand3 = null;
        for (String string2 : stringArray) {
            SkillsCommand skillsCommand4 = skillsCommand3;
            Stream<SkillsCommand> stream = skillsCommand3 == null ? commands.stream().filter(skillsCommand -> skillsCommand.isGroup() && skillsCommand.getName().equalsIgnoreCase(string2)) : commands.stream().filter(skillsCommand2 -> skillsCommand2.isGroup() && skillsCommand2.getName().equalsIgnoreCase(string2) && skillsCommand4.equals(skillsCommand2.getGroup()));
            SkillsCommand skillsCommand5 = stream.findFirst().orElse(null);
            if (skillsCommand5 == null) {
                return null;
            }
            skillsCommand3 = skillsCommand5;
        }
        String[] stringArray2 = skillsCommand3;
        return commands.stream().filter(arg_0 -> SkillsCommandHandler.lambda$getCommand$3((SkillsCommand)stringArray2, arg_0)).findFirst().orElse(null);
    }

    public static boolean isCommand(String string) {
        return commands.stream().anyMatch(skillsCommand -> skillsCommand.matchesNames(string));
    }

    public static void executeHelperForGroup(SkillsCommand skillsCommand2, CommandSender commandSender) {
        List<SkillsCommand> list = Arrays.asList(skillsCommand2.getSubCommands());
        SkillsCommand[] skillsCommandArray = (SkillsCommand[])list.stream().filter(skillsCommand -> skillsCommand.hasPermission(commandSender)).toArray(SkillsCommand[]::new);
        SkillsLang.COMMAND_HELP_GROUPED_HEADER.sendMessage(commandSender, "%group%", StringUtils.capitalize(skillsCommand2.getName()));
        for (SkillsCommand skillsCommand3 : skillsCommandArray) {
            StringBuilder stringBuilder = new StringBuilder(skillsCommand3.getName());
            for (SkillsCommand skillsCommand4 = skillsCommand3.getGroup(); skillsCommand4 != null; skillsCommand4 = skillsCommand4.getGroup()) {
                stringBuilder.insert(0, skillsCommand4.getName() + ' ');
            }
            SkillsLang.COMMAND_HELP_GROUPED_COMMANDS.sendMessage(commandSender, "%cmd%", stringBuilder, "%description%", skillsCommand3.getDescription());
        }
    }

    public static void sendUsage(CommandSender commandSender, String string) {
        MessageHandler.sendMessage(commandSender, SkillsLang.Command_Usage.parse(new Object[0]) + string);
    }

    public static void sendNotNumber(CommandSender commandSender, String string, String string2) {
        SkillsLang.Command_Not_Number.sendMessage(commandSender, "%needed%", string, "%arg%", string2);
    }

    protected static Pair<SkillsCommand, Integer> getLastCommand(String[] stringArray) {
        int n;
        if (stringArray.length == 1) {
            return new Pair<SkillsCommand, Integer>(commands.stream().filter(skillsCommand -> skillsCommand.getGroup() == null && skillsCommand.matchesNames(stringArray[0])).findFirst().orElse(null), 0);
        }
        SkillsCommand skillsCommand3 = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            SkillsCommand skillsCommand4 = skillsCommand3;
            Stream<SkillsCommand> stream = skillsCommand3 == null ? commands.stream().filter(skillsCommand -> skillsCommand.matchesNames(string) && skillsCommand.getGroup() == null) : commands.stream().filter(skillsCommand2 -> skillsCommand2.matchesNames(string) && skillsCommand4.equals(skillsCommand2.getGroup()));
            SkillsCommand skillsCommand5 = stream.findFirst().orElse(null);
            if (skillsCommand5 == null) {
                --n;
                break;
            }
            skillsCommand3 = skillsCommand5;
        }
        return new Pair<Object, Integer>(skillsCommand3, n);
    }

    public boolean onCommand(@NonNull CommandSender commandSender, @NonNull Command command, @NonNull String string, @NonNull String[] stringArray) {
        if (stringArray.length == 0) {
            SkillsCommand skillsCommand = SkillsCommandHandler.getCommand("help", new String[0]);
            skillsCommand.plugin = this.plugin;
            skillsCommand.runCommand(commandSender, stringArray);
            return true;
        }
        Pair<SkillsCommand, Integer> pair = SkillsCommandHandler.getLastCommand(stringArray);
        SkillsCommand skillsCommand = pair.getKey();
        int n = pair.getValue();
        if (skillsCommand == null) {
            SkillsLang.Command_Unknown.sendMessage(commandSender, new Object[0]);
            if (commandSender instanceof Player) {
                XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)((Player)commandSender));
            }
            return false;
        }
        if (skillsCommand.hasPermission(commandSender)) {
            skillsCommand.plugin = this.plugin;
            String[] stringArray2 = (String[])Arrays.stream(stringArray).skip(n + 1).toArray(String[]::new);
            skillsCommand.runCommand(commandSender, stringArray2);
            return true;
        }
        SkillsLang.PERMISSION.sendMessage(commandSender, new Object[0]);
        XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)((Player)commandSender));
        return false;
    }

    private static /* synthetic */ boolean lambda$getCommand$3(SkillsCommand skillsCommand, SkillsCommand skillsCommand2) {
        return skillsCommand2.getGroup().equals(skillsCommand);
    }

    protected static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

