/*
 * Decompiled with CFR 0.152.
 */
package org.skills.commands;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.skills.commands.SkillsCommandHandler;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public abstract class SkillsCommand {
    private final @NonNull String permission;
    private final @NonNull String name;
    private final @Nullable SkillsCommand group;
    private final @Nullable String description;
    private final boolean isGroup;
    private final @NonNull String[] aliases;
    public SkillsPro plugin;

    public SkillsCommand(@NonNull String string, @Nullable SkillsCommand skillsCommand, @Nullable String string2, boolean bl, String ... stringArray) {
        this.name = string;
        this.group = skillsCommand;
        this.description = string2;
        this.isGroup = bl;
        this.aliases = stringArray;
        if (this.isDisabled()) {
            this.permission = null;
            return;
        }
        SkillsCommand skillsCommand2 = skillsCommand;
        StringBuilder stringBuilder = new StringBuilder();
        while (skillsCommand2 != null) {
            stringBuilder.insert(0, skillsCommand2.name + '.');
            skillsCommand2 = skillsCommand2.group;
        }
        this.permission = "skills.command." + stringBuilder + this.name;
        SkillsCommandHandler.commands.add(this);
        if (this instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SkillsPro.get());
        }
    }

    public SkillsCommand(@NonNull String string, @Nullable SkillsCommand skillsCommand, @NonNull SkillsLang skillsLang, boolean bl, String ... stringArray) {
        this(string, skillsCommand, skillsLang.parse(new Object[0]), bl, stringArray);
    }

    public SkillsCommand(@NonNull String string, @Nullable SkillsCommand skillsCommand, @NonNull SkillsLang skillsLang, String ... stringArray) {
        this(string, skillsCommand, skillsLang.parse(new Object[0]), false, stringArray);
    }

    public SkillsCommand(@NonNull String string, @NonNull SkillsLang skillsLang, boolean bl, String ... stringArray) {
        this(string, null, skillsLang.parse(new Object[0]), bl, stringArray);
    }

    public SkillsCommand(@NonNull String string, @NonNull SkillsLang skillsLang, String ... stringArray) {
        this(string, null, skillsLang.parse(new Object[0]), false, stringArray);
    }

    public SkillsCommand(@NonNull String string, @NonNull String string2, String ... stringArray) {
        this(string, null, string2, false, stringArray);
    }

    public void sendUsage(CommandSender commandSender, SkillsLang skillsLang) {
        MessageHandler.sendMessage(commandSender, SkillsLang.Command_Usage.parse(new Object[0]) + skillsLang.parse(new Object[0]));
    }

    public boolean hasPermission(@NonNull CommandSender commandSender) {
        return commandSender.hasPermission(this.permission);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SkillsCommand)) {
            return false;
        }
        SkillsCommand skillsCommand = (SkillsCommand)object;
        return this.isGroup == skillsCommand.isGroup && this.name.equals(skillsCommand.name) && Objects.equals(this.group, skillsCommand.group) && Objects.equals(this.description, skillsCommand.description) && Arrays.equals(this.aliases, skillsCommand.aliases);
    }

    private boolean isDisabled() {
        SkillsCommand skillsCommand = this.group;
        StringBuilder stringBuilder = new StringBuilder(this.name);
        while (skillsCommand != null) {
            stringBuilder.insert(0, skillsCommand.name + ' ');
            skillsCommand = skillsCommand.group;
        }
        for (String string : SkillsConfig.DISABLED_COMMANDS.getStringList()) {
            if ((string = StringUtils.deleteWhitespace((String)string.toLowerCase())).charAt(0) == '/') {
                string = string.substring(string.indexOf(32) + 1);
            }
            if (!stringBuilder.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public OfflinePlayer getPlayer(CommandSender commandSender, String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player == null && !(player = Bukkit.getOfflinePlayer((String)string)).hasPlayedBefore()) {
            player = null;
        }
        if (commandSender != null && player == null) {
            SkillsLang.NOT_FOUND_PLAYER.sendMessage(commandSender, "%name%", string);
        }
        return player;
    }

    public abstract void runCommand(@NonNull CommandSender var1, @NonNull String[] var2);

    public abstract String[] tabComplete(@NonNull CommandSender var1, @NonNull String[] var2);

    public @NonNull SkillsCommand[] getSubCommands() {
        if (!this.isGroup) {
            return new SkillsCommand[0];
        }
        return (SkillsCommand[])SkillsCommandHandler.commands.stream().filter(skillsCommand -> this.equals(skillsCommand.group)).toArray(SkillsCommand[]::new);
    }

    public boolean matchesNames(String string) {
        return this.name.equalsIgnoreCase(string) || Arrays.asList(this.aliases).contains(string.toLowerCase());
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @Nullable String[] getAliases() {
        return this.aliases;
    }

    public @Nullable SkillsCommand getGroup() {
        return this.group;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public @Nullable String getDescription() {
        return this.description;
    }
}

