/*
 * Decompiled with CFR 0.152.
 */
package org.skills.api.events;

import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.skills.data.managers.SkilledPlayer;
import org.skills.managers.LevelUp;

public class SkillLevelUpEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final SkilledPlayer info;
    private final Player player;
    private int level;
    private boolean cancelled;

    public SkillLevelUpEvent(SkilledPlayer skilledPlayer, Player player, int n) {
        this.info = skilledPlayer;
        this.player = player;
        this.level = n;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public int getNewLevel() {
        return this.info.getLevel() + this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getAddedLevel() {
        return this.level;
    }

    public void setAddedLevel(int n) {
        this.level = n;
    }

    public LevelUp getLevelProperties() {
        return LevelUp.getProperties(this.getNewLevel());
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public SkilledPlayer getInfo() {
        return this.info;
    }
}

