/*
 * Decompiled with CFR 0.152.
 */
package org.skills.api.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.messages.ActionBar;

public class CustomHudChangeEvent
extends Event
implements Cancellable {
    public static final Set<UUID> ANIMATIONS = new HashSet<UUID>();
    private static final Map<UUID, Integer> BOSSBAR_SCHEDULERS = new HashMap<UUID, Integer>();
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private String hud;
    private boolean cancelled;

    public CustomHudChangeEvent(Player player) {
        super(true);
        SkilledPlayer skilledPlayer;
        this.player = player;
        if (ServiceHandler.isNPC((Entity)player)) {
            return;
        }
        if (!ANIMATIONS.remove(player.getUniqueId())) {
            ANIMATIONS.add(player.getUniqueId());
        }
        this.hud = (skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player)).isActiveReady() ? SkillsConfig.ACTIONBAR_ACTIVATED_SKILL.parse((OfflinePlayer)player, new Object[0]) : SkillsConfig.ACTIONBAR_NORMAL.parse((OfflinePlayer)player, new Object[0]);
    }

    public static void call(Player player) {
        int n;
        if (SkillsConfig.ACTIONBAR_FREQUENCY.getInt() <= 0) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
                if (player.hasPermission("skills.actionbar") && !SkillsConfig.isInDisabledWorld(player.getLocation())) {
                    CustomHudChangeEvent customHudChangeEvent = new CustomHudChangeEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)customHudChangeEvent);
                    if (!customHudChangeEvent.cancelled) {
                        ActionBar.sendActionBar(player, customHudChangeEvent.hud);
                    }
                }
            });
        }
        if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && player.hasPermission("skills.bossbar") && !SkillsConfig.isInDisabledWorld(player.getLocation()) && (n = SkillsConfig.BOSSBAR_LEVELS_FREQUENCY.getInt()) < 0) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
                BossBar bossBar = HealthAndEnergyManager.getBossBar(player);
                if (bossBar == null) {
                    return;
                }
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
                float f = (float)(skilledPlayer.getXP() / skilledPlayer.getLevelXP(skilledPlayer.getLevel()));
                bossBar.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.BOSSBAR_LEVELS.getSection().getString("title"))));
                bossBar.setProgress((double)f);
                bossBar.addPlayer(player);
                Integer n2 = BOSSBAR_SCHEDULERS.remove(player.getUniqueId());
                if (n2 != null) {
                    Bukkit.getScheduler().cancelTask(n2.intValue());
                }
                int n3 = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SkillsPro.get(), () -> bossBar.removePlayer(player), (long)(-n) * 20L).getTaskId();
                BOSSBAR_SCHEDULERS.put(player.getUniqueId(), n3);
            });
        }
    }

    public static boolean isAnimated(UUID uUID) {
        return ANIMATIONS.contains(uUID);
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public SkilledPlayer getPlayerInfo() {
        return SkilledPlayer.getSkilledPlayer((OfflinePlayer)this.player);
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getHud() {
        return this.hud;
    }

    public void setHud(String string) {
        this.hud = string;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

