/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class VergilVerticalSlash
extends ActiveAbility {
    private static final Cache<UUID, Integer> UPPER_DOWN = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();

    public VergilVerticalSlash() {
        super("Vergil", "vertical_slash");
        this.setPvPBased(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        SkilledPlayer skilledPlayer;
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.SWEEP_ATTACK).rotate(ParticleDisplay.Rotation.of(-1.5707963267948966, ParticleDisplay.Axis.Z)).face((Entity)player).withLocation(player.getEyeLocation());
        if (player.isSneaking() && UPPER_DOWN.getIfPresent((Object)player.getUniqueId()) != null) {
            UPPER_DOWN.invalidate((Object)player.getUniqueId());
            Particles.ellipse(0.0, Math.PI, 0.10471975511965977, 3.0, 4.0, particleDisplay);
            Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                double d = 1.0;
                for (Entity entity : player.getWorld().getNearbyEntities(livingEntity.getLocation(), d, d, d)) {
                    if (EntityUtil.filterEntity(player, entity)) continue;
                    entity.setVelocity(new Vector(0, -4, 0));
                }
                if (player.isSneaking()) {
                    player.setVelocity(new Vector(0, -1, 0));
                    UPPER_DOWN.put((Object)player.getUniqueId(), (Object)0);
                }
            }, 1L);
        }
        if ((skilledPlayer = this.checkup(player)) == null) {
            return;
        }
        Particles.ellipse(0.0, Math.PI, 0.10471975511965977, 3.0, 4.0, particleDisplay);
        RayTraceResult rayTraceResult = player.getWorld().rayTraceBlocks(player.getLocation(), new Vector(0, -1, 0), 5.0, FluidCollisionMode.SOURCE_ONLY, true);
        boolean bl = rayTraceResult != null && rayTraceResult.getHitBlock() != null;
        double d = 1.0;
        Vector vector = new Vector(0.0, bl ? d : -d, 0.0);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            double d = 2.0;
            for (Entity entity : player.getWorld().getNearbyEntities(livingEntity.getLocation(), d, d, d)) {
                if (EntityUtil.filterEntity(player, entity)) continue;
                entity.setVelocity(vector);
            }
            if (player.isSneaking()) {
                player.setVelocity(vector);
                UPPER_DOWN.put((Object)player.getUniqueId(), (Object)0);
            }
        }, 1L);
    }
}

