/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import java.util.concurrent.TimeUnit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.util.RayTraceResult;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.managers.DamageManager;
import org.skills.managers.MoveManager;
import org.skills.utils.Cooldown;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VergilTrickAction
extends InstantActiveAbility {
    private static final String TRICK_BEHIND = "TRICK_BEHIND";

    public VergilTrickAction() {
        super("Vergil", "trick_action");
        this.setPvPBased(false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTrickBehind(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckupReverse(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        SkilledPlayer skilledPlayer = this.basicCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        new Cooldown(player.getUniqueId(), TRICK_BEHIND, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Location location;
        Player player = abilityContext.getPlayer();
        Location location2 = player.getEyeLocation();
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.CLOUD).withCount(200).offset(1.0);
        particleDisplay.spawn(location2.clone());
        SLogger.info("last on ground: " + MoveManager.getLastTimeOnGround(player).toMillis());
        boolean bl = true;
        if (player.isSneaking() && Cooldown.isInCooldown(player.getUniqueId(), TRICK_BEHIND)) {
            LivingEntity livingEntity = DamageManager.getLastSourceDamager(player, true);
            location = livingEntity.getLocation().add(livingEntity.getLocation().getDirection().multiply(-2));
            location.setDirection(location.toVector().subtract(livingEntity.getLocation().toVector()).multiply(-1));
            bl = false;
        } else if (!player.isOnGround()) {
            location = player.getLocation().add(0.0, 7.0, 0.0);
            if (XPotion.SLOW_FALLING.isSupported()) {
                player.addPotionEffect(XPotion.SLOW_FALLING.buildPotionEffect(100, 20));
            }
        } else {
            RayTraceResult rayTraceResult = player.getWorld().rayTrace(player.getEyeLocation(), player.getEyeLocation().getDirection(), 50.0, FluidCollisionMode.SOURCE_ONLY, true, 2.0, entity -> player != entity && entity instanceof LivingEntity);
            location = rayTraceResult != null ? (rayTraceResult.getHitBlock() != null ? rayTraceResult.getHitBlock().getLocation().add(0.0, 1.0, 0.0) : (rayTraceResult.getHitEntity() != null ? rayTraceResult.getHitEntity().getLocation() : rayTraceResult.getHitPosition().toLocation(player.getWorld()))) : player.getLocation().add(player.getLocation().getDirection().normalize().multiply(30));
        }
        if (bl) {
            location.setYaw(location2.getYaw());
            location.setPitch(location2.getPitch());
        }
        particleDisplay.spawn(location);
        player.teleport(location);
    }
}

