/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.managers.MoveManager;
import org.skills.utils.Cooldown;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VergilRapidSlash
extends InstantActiveAbility {
    private static final String SLASH_MODE = "VERGIL_SLASH_MODE";
    private static final Map<UUID, List<LivingEntity>> SLASHED = new HashMap<UUID, List<LivingEntity>>();

    public VergilRapidSlash() {
        super("Vergil", "rapid_slash");
        this.setPvPBased(true);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR && playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        VergilRapidSlash.onAttack(playerInteractEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            VergilRapidSlash.onAttack((Player)entityDamageByEntityEvent.getDamager());
        }
    }

    private static void onAttack(Player player) {
        if (MoveManager.isMoving(player)) {
            return;
        }
        if (!Cooldown.isInCooldown(player.getUniqueId(), SLASH_MODE)) {
            return;
        }
        double d = 3.0;
        Location location = player.getEyeLocation().add(player.getEyeLocation().getDirection().normalize().multiply(2));
        ParticleDisplay.of(XParticle.SWEEP_ATTACK).withCount(30).offset(1.5).spawn(location);
        XSound.ENTITY_PLAYER_ATTACK_SWEEP.play(location);
        List list = SLASHED.computeIfAbsent(player.getUniqueId(), uUID -> new ArrayList());
        for (Entity entity : player.getWorld().getNearbyEntities(location, d, d, d)) {
            if (EntityUtil.filterEntity(player, entity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            DamageManager.damage(livingEntity, null, 0.5);
            list.add(livingEntity);
            DamageManager.storeDamageTicks(livingEntity);
            livingEntity.setNoDamageTicks(1);
        }
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        new Cooldown(player.getUniqueId(), SLASH_MODE, 10L, TimeUnit.SECONDS);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> SLASHED.remove(player.getUniqueId()).forEach(DamageManager::restoreDamageTicks), 200L);
    }
}

