/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.utils.DisplayEntityUtil;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VergilPhantomBlade
extends InstantActiveAbility {
    private static final Cache<UUID, Boolean> LAST_SHOULDER = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Integer> COOLDOWN = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Integer> HOLD = CacheBuilder.newBuilder().expireAfterWrite(300L, TimeUnit.MILLISECONDS).build();
    private static final Map<Integer, ArmorStand> SWORDS = new ConcurrentHashMap<Integer, ArmorStand>();
    private static final ParticleDisplay SWORD_PARTICLE = ParticleDisplay.of(XParticle.DRAGON_BREATH).withCount(5);

    public VergilPhantomBlade() {
        super("Vergil", "phantom_blade");
        this.setPvPBased(true);
    }

    @EventHandler
    public void onHoldActivation(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (XMaterial.matchXMaterial(player.getInventory().getItemInMainHand()) != XMaterial.STICK) {
            return;
        }
        Integer n = (Integer)HOLD.getIfPresent((Object)player.getUniqueId());
        if (n == null) {
            HOLD.put((Object)player.getUniqueId(), (Object)1);
            return;
        }
        SLogger.info("Called interact " + n);
        if (n >= 10) {
            VergilPhantomBlade.guardingPhantomBlades(player);
            HOLD.invalidate((Object)player.getUniqueId());
        } else {
            HOLD.put((Object)player.getUniqueId(), (Object)(n + 1));
        }
    }

    public static void guardingPhantomBlades(Player player) {
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        Location location = player.getEyeLocation().add(3.0, 0.0, 0.0);
        Location location2 = player.getEyeLocation().add(-3.0, 0.0, 0.0);
        Boolean bl = (Boolean)LAST_SHOULDER.getIfPresent((Object)player.getUniqueId());
        if (bl == null) {
            bl = true;
        }
        if (bl.booleanValue()) {
            Location location3 = location2;
        } else {
            Location location4 = location;
        }
        LAST_SHOULDER.put((Object)player.getUniqueId(), (Object)(bl == false ? 1 : 0));
        RayTraceResult rayTraceResult = player.getWorld().rayTrace(player.getEyeLocation(), player.getEyeLocation().getDirection(), 50.0, FluidCollisionMode.ALWAYS, true, 0.5, entity -> entity != player);
        Location location5 = player.getEyeLocation();
        COOLDOWN.put((Object)player.getUniqueId(), (Object)0);
        DisplayEntityUtil.spawnDisplay(player, location5);
    }

    static {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SkillsPro.get(), () -> {
            Iterator<ArmorStand> iterator = SWORDS.values().iterator();
            while (iterator.hasNext()) {
                ArmorStand armorStand = iterator.next();
                if (!armorStand.isValid() || armorStand.isDead()) {
                    iterator.remove();
                    continue;
                }
                SWORD_PARTICLE.spawn(LocationUtils.getArmorStandHandLocation(armorStand));
            }
        }, 100L, 5L);
    }
}

