/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.api.events.ClassChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VergilPassive
extends Ability {
    public static final Map<UUID, BossBar> MOTIVATION_LEVELS = new HashMap<UUID, BossBar>();
    private static final int SWORD_ATTACK_SPEED_MILLIS = 625;
    private static final Cache<UUID, Long> LAST_ATTACK = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.MILLISECONDS).build();

    public static int getMotivationLevelFromProgress(double d) {
        if (d >= 0.9) {
            return 3;
        }
        if (d >= 0.6) {
            return 2;
        }
        if (d >= 0.3) {
            return 1;
        }
        return 0;
    }

    public static int getMotivationLevel(Player player) {
        BossBar bossBar = MOTIVATION_LEVELS.get(player.getUniqueId());
        return bossBar == null ? -1 : VergilPassive.getMotivationLevelFromProgress(bossBar.getProgress());
    }

    public VergilPassive() {
        super("Vergil", "passive");
    }

    public void motivate(Player player, double d) {
        BarColor barColor;
        if (d == 0.0) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        BossBar bossBar = MOTIVATION_LEVELS.get(player.getUniqueId());
        if (d != 2.147483647E9 && bossBar != null && (d < 0.0 ? bossBar.getProgress() <= 0.0 : bossBar.getProgress() >= 1.0)) {
            return;
        }
        ConfigurationSection configurationSection = skilledPlayer.getSkill().getAdapter().getConfig().getConfigurationSection("concentration-bossbar");
        if (bossBar == null) {
            bossBar = StringUtils.parseBossBarFromConfig(null, configurationSection);
            bossBar.setProgress(0.0);
            bossBar.addPlayer(player);
            MOTIVATION_LEVELS.put(player.getUniqueId(), bossBar);
        }
        String string = configurationSection.getString("title");
        if (d != 2.147483647E9) {
            bossBar.setProgress(Math.min(1.0, Math.max(0.0, bossBar.getProgress() + (d /= 100.0))));
        }
        switch (VergilPassive.getMotivationLevelFromProgress(bossBar.getProgress())) {
            case 3: {
                barColor = BarColor.BLUE;
                break;
            }
            case 2: {
                barColor = BarColor.GREEN;
                break;
            }
            case 1: {
                barColor = BarColor.YELLOW;
                break;
            }
            default: {
                barColor = BarColor.RED;
            }
        }
        bossBar.setColor(barColor);
        bossBar.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string)));
    }

    public static void removeMotivationMeter(UUID uUID) {
        BossBar bossBar = MOTIVATION_LEVELS.remove(uUID);
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSkillChange(ClassChangeEvent classChangeEvent) {
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            if (classChangeEvent.getInfo().getSkill().hasAbility(this)) {
                Player player = classChangeEvent.getInfo().getPlayer();
                this.motivate(player, 2.147483647E9);
            } else {
                VergilPassive.removeMotivationMeter(classChangeEvent.getInfo().getId());
            }
        }, 1L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)playerJoinEvent.getPlayer());
        if (skilledPlayer.getSkill().hasAbility(this)) {
            this.motivate(playerJoinEvent.getPlayer(), 2.147483647E9);
        }
    }

    public static boolean isCriticalHit(Player player) {
        return player.getFallDistance() > 0.0f && !player.isOnGround() && !player.isSprinting() && !player.hasPotionEffect(XPotion.BLINDNESS.getPotionEffectType()) && player.getVehicle() == null;
    }

    @EventHandler
    public void onSkillDamageCap(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR && playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (XMaterial.matchXMaterial(player.getItemInHand()) != XMaterial.IRON_SWORD) {
            return;
        }
        LAST_ATTACK.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onConcentration(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType().name().endsWith("_SWORD") && LAST_ATTACK.getIfPresent((Object)player.getUniqueId()) == null && !entityDamageByEntityEvent.isCancelled()) {
            SLogger.info("MOTIVATED");
            boolean bl = VergilPassive.isCriticalHit(player);
            this.motivate(player, bl ? 2.0 : 1.0);
            LAST_ATTACK.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        }
    }

    private static /* synthetic */ void lambda$onSkillDamageCap$3() {
    }

    static {
        Bukkit.getScheduler().runTaskTimer((Plugin)SkillsPro.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                int n = VergilPassive.getMotivationLevel(player);
            }
        }, 0L, 200L);
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.FLAME).offset(0.5).withExtra(0.5);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SkillsPro.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                int n = VergilPassive.getMotivationLevel(player);
                if (n < 2) continue;
                Location location = player.getLocation();
                for (double d = 0.0; d < player.getHeight(); d += 0.1) {
                    particleDisplay.spawn(location.clone().add(0.0, d, 0.0));
                }
            }
        }, 0L, 1L);
    }
}

