/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AtomicDouble;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.utils.EntityUtil;
import org.skills.utils.ParticleUtil;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class VergilMirageEdgeSlash
extends InstantActiveAbility {
    public VergilMirageEdgeSlash() {
        super("Vergil", "mirage_edge_slash");
        this.setPvPBased(true);
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        Vector vector = player.getEyeLocation().getDirection().normalize();
        Vector vector2 = ParticleUtil.getPerpendicularVector(vector).normalize();
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(100L, TimeUnit.MILLISECONDS).build();
        double d = abilityContext.getScaling("distance");
        double d2 = abilityContext.getScaling("size");
        double d3 = abilityContext.getScaling("damage");
        double d4 = abilityContext.getScaling("knockback");
        double d5 = abilityContext.getScaling("range");
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.SOUL_FIRE_FLAME).withLocation(player.getEyeLocation()).face((Entity)player).withExtra(0.1).rotate(ParticleDisplay.Rotation.of(-1.5707963267948966, vector2)).postCalculation(calculationContext -> {
            Location location = calculationContext.getLocation();
            Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                for (Entity entity : location.getWorld().getNearbyEntities(location, d5, d5, d5)) {
                    if (EntityUtil.filterEntity(player, entity) || cache.getIfPresent((Object)entity.getEntityId()) != null) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    DamageManager.damage(livingEntity, player, d3);
                    EntityUtil.knockBack((Entity)livingEntity, vector, d4);
                    XSound.ENTITY_WARDEN_ATTACK_IMPACT.record().withPitch(0.5f).soundPlayer().atLocation(livingEntity.getEyeLocation()).play();
                    cache.put((Object)entity.getEntityId(), (Object)false);
                }
            });
        });
        AtomicDouble atomicDouble = new AtomicDouble(d2);
        Particles.slash((Plugin)SkillsPro.get(), d, true, () -> atomicDouble.getAndAdd(-0.01), () -> 0.3, particleDisplay);
        if (abilityContext.hasAbilityLevel(3)) {
            Particles.slash((Plugin)SkillsPro.get(), d, true, () -> ((AtomicDouble)atomicDouble).get(), () -> 0.3, particleDisplay.clone().withParticle(XParticle.DUST).withColor(Color.RED, 1.0f));
        }
        XSound.ENTITY_WARDEN_DEATH.record().withPitch(0.0f).soundPlayer().atLocation(player.getEyeLocation()).play();
    }
}

