/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.utils.EntityUtil;
import org.skills.utils.LocationUtils;
import org.skills.utils.Pair;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class VergilJudgementCutEnd
extends InstantActiveAbility {
    private static final Map<UUID, Location> PERFORMING = new HashMap<UUID, Location>();

    public VergilJudgementCutEnd() {
        super("Vergil", "judgement_cut_end");
        this.setPvPBased(true);
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        final double d = 10.0;
        final Location location = player.getLocation();
        player.setInvulnerable(true);
        final ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.TRIAL_SPAWNER_DETECTION).withCount(1000).offset(d).withLocation(player.getEyeLocation());
        final ParticleDisplay particleDisplay2 = ParticleDisplay.of(XParticle.WARPED_SPORE).withCount(1000).offset(d).withLocation(player.getEyeLocation().add(0.0, 3.0, 0.0));
        final ParticleDisplay particleDisplay3 = ParticleDisplay.of(XParticle.FLAME).withLocation(player.getEyeLocation());
        new BukkitRunnable(){
            int times = 10;

            public void run() {
                particleDisplay.spawn();
                particleDisplay2.spawn();
                Particles.sphere(d, 30.0, particleDisplay3);
                if (--this.times == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 20L);
        PERFORMING.put(player.getUniqueId(), location);
        ParticleDisplay particleDisplay4 = ParticleDisplay.of(XParticle.FLAME).withLocation(player.getEyeLocation());
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            final ArrayList<Pair<Object, Runnable>> arrayList = new ArrayList<Pair<Object, Runnable>>();
            for (Entity entity : player.getNearbyEntities(d, d, d)) {
                if (EntityUtil.filterEntity(player, entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof Player) {
                    Player player2 = (Player)entity;
                    float f = player2.getWalkSpeed();
                    float f2 = player2.getFlySpeed();
                    player2.setWalkSpeed(-100.0f);
                    player2.setFlySpeed(-100.0f);
                    entity.setGravity(false);
                    arrayList.add(Pair.of(player2, () -> {
                        player2.setWalkSpeed(f);
                        player2.setFlySpeed(f2);
                        player2.setGravity(true);
                    }));
                    continue;
                }
                livingEntity.setAI(false);
                entity.setGravity(false);
                arrayList.add(Pair.of(livingEntity, () -> {
                    livingEntity.setAI(true);
                    entity.setGravity(true);
                }));
            }
            new BukkitRunnable(){
                final int slashes = 20;
                final ThreadLocalRandom rand = ThreadLocalRandom.current();
                static final int randomRange = 3;
                final Iterator<LivingEntity> iteratedTargets = arrayList.stream().map(Pair::getKey).iterator();

                public void run() {
                    if (!this.iteratedTargets.hasNext()) {
                        this.cancel();
                        player.setInvulnerable(false);
                        player.teleport(location);
                        PERFORMING.remove(player.getUniqueId());
                        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                            ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.SWEEP_ATTACK).withCount(20).offset(2.0);
                            for (Pair pair : arrayList) {
                                ((Runnable)pair.getValue()).run();
                                LivingEntity livingEntity = (LivingEntity)pair.getKey();
                                DamageManager.damage(livingEntity, null, 10.0);
                                XSound.ENTITY_PLAYER_ATTACK_SWEEP.record().soundPlayer().atLocation(livingEntity.getLocation()).play();
                                particleDisplay.spawn(livingEntity.getLocation());
                                livingEntity.setVelocity(livingEntity.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().multiply(3));
                            }
                        }, 60L);
                    } else {
                        Location location2 = this.iteratedTargets.next().getLocation();
                        player.setVelocity(location2.toVector().subtract(player.getLocation().toVector()).normalize().multiply(3));
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 5L);
        }, 140L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onOutOfBounds(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        Location location = PERFORMING.get(player.getUniqueId());
        if (location != null && LocationUtils.distanceSquared(location, player.getLocation()) >= 15.0) {
            player.setVelocity(player.getVelocity().multiply(-2));
        }
    }
}

