/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.abilities.vergil.AAAA;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.utils.EntityUtil;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class VergilJudgementCut
extends InstantActiveAbility {
    private static final Cache<UUID, Integer> PERFECT_JUDGEMENT_CUTS = CacheBuilder.newBuilder().expireAfterAccess(500L, TimeUnit.MILLISECONDS).build();

    public VergilJudgementCut() {
        super("Vergil", "judgement_cut");
        this.setPvPBased(true);
    }

    public static BukkitTask helix(Plugin plugin, int n, double d, double d2, double d3, int n2, int n3, boolean bl, boolean bl2, ParticleDisplay particleDisplay, Entity entity) {
        final BooleanSupplier booleanSupplier = VergilJudgementCut.helix(n, d, d2, d3, n2, n3, bl, bl2, particleDisplay, entity);
        return new BukkitRunnable(){

            public void run() {
                if (!booleanSupplier.getAsBoolean()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, (long)n3);
    }

    public static BooleanSupplier helix(int n, double d, double d2, double d3, int n2, int n3, boolean bl, boolean bl2, ParticleDisplay particleDisplay, final Entity entity) {
        Location location = particleDisplay.getLocation();
        final Location location2 = location.clone();
        World world = location.getWorld();
        Vector vector = location.getDirection();
        return new BooleanSupplier(){
            double particleDistance = 1.0;
            final int maxBeamLength = 30;
            final int beamLength = 0;
            final double targetHeight = 0.0;
            final int ticks = 0;
            final int ticksPerParticle = 3;
            final boolean fadeDown = false;
            final boolean fadeUp = false;
            final double length = 10.0;
            final double rate = 0.1;
            final double radius = 1.0;
            final int strings = 2;
            final double distanceBetweenEachCirclePoints = Math.PI;
            final double radiusDiv = 0.01;
            final double radiusDiv2 = 0.01;
            double dynamicRadius = 1.0;
            boolean center = true;
            final double rotationRate = 0.4487989505128276;
            double rotation = 0.0;

            @Override
            public boolean getAsBoolean() {
                Vector vector = null;
                vector = location2.getDirection().clone().multiply(this.particleDistance);
                location2.add(vector);
                if (!this.center) {
                    this.dynamicRadius += 0.01;
                    if (this.dynamicRadius >= 1.0) {
                        this.center = true;
                    }
                }
                for (double d = 0.0; d < 2.0; d += 1.0) {
                    double d2 = d * Math.PI + this.rotation;
                    double d3 = 2.0 * Math.cos(d2);
                    double d4 = 2.0 * Math.sin(d2);
                    Location location = location2.clone();
                    location.setPitch(location.getPitch() - 20.0f);
                    location.setYaw(location.getYaw() + 20.0f);
                    ParticleDisplay.of(XParticle.FLAME).withLocation(location2.clone()).face(location).spawn(d3, 0.0, d4);
                }
                this.rotation += 0.4487989505128276;
                return true;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void useSkill(AbilityContext abilityContext) {
        Entity entity;
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        Player player = abilityContext.getPlayer();
        SLogger.info("passed 1");
        World world = player.getWorld();
        SLogger.info("passed 2");
        EntityDamageByEntityEvent entityDamageByEntityEvent2 = DamageManager.getLastDamager(player, true);
        if (entityDamageByEntityEvent2 == null) {
            entityDamageByEntityEvent = DamageManager.getLastHitEntity(player);
            if (entityDamageByEntityEvent == null) return;
            entity = entityDamageByEntityEvent.getEntity();
        } else {
            entity = entityDamageByEntityEvent2.getDamager();
        }
        SLogger.info("passed 3");
        entityDamageByEntityEvent = world.rayTrace(player.getEyeLocation(), player.getEyeLocation().getDirection(), 50.0, FluidCollisionMode.ALWAYS, true, 2.0, null);
        if (entityDamageByEntityEvent != null) {
            SLogger.info("ray: " + entityDamageByEntityEvent.getHitBlock() + ' ' + entityDamageByEntityEvent.getHitEntity());
        }
        SLogger.info("passed 4");
        Location location = entity.getLocation();
        this.dustToDust(player, entity, location, 1);
    }

    public void dustToDust(Player player, Entity entity, Location location, int n) {
        XSound.ENTITY_WARDEN_SONIC_BOOM.play(player.getEyeLocation());
        if (player.isSneaking()) {
            AAAA.particleTutorial(player, entity);
            return;
        }
        World world = player.getWorld();
        XSound.ENTITY_WARDEN_DIG.play(player.getEyeLocation());
        double d = LocationUtils.distance(player.getLocation(), location);
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.FLAME).withCount(1).withLocation(player.getEyeLocation());
        ParticleDisplay particleDisplay2 = ParticleDisplay.of(XParticle.FLAME).withCount(1).withLocation(player.getEyeLocation()).face((Entity)player);
        BukkitTask bukkitTask = VergilJudgementCut.helix((Plugin)SkillsPro.get(), 2, 1.0, 0.7, 1.0, 100, 1, false, false, particleDisplay2, entity);
        Particles.helix((Plugin)SkillsPro.get(), 2, 2.0, 0.1, 1.0, 5.0, 0.1, 20.0, false, false, ParticleDisplay.of(XParticle.DRAGON_BREATH).withLocation(player.getLocation()).withDirection(new Vector(0, 1, 0)));
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            LivingEntity livingEntity;
            SLogger.info("passed 5");
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            for (int i = 0; i < 10; ++i) {
                double d = 4.0;
                Entity entity = location.clone().add(threadLocalRandom.nextDouble(-d, d), threadLocalRandom.nextDouble(-d, d), threadLocalRandom.nextDouble(-d, d));
                livingEntity = location.clone().add(threadLocalRandom.nextDouble(-d, d), threadLocalRandom.nextDouble(-d, d), threadLocalRandom.nextDouble(-d, d));
                Particles.line((Location)entity, (Location)livingEntity, 0.3, particleDisplay);
            }
            double d = 5.0;
            for (Entity entity : world.getNearbyEntities(location, d, d, d)) {
                if (EntityUtil.filterEntity(player, entity)) continue;
                livingEntity = (LivingEntity)entity;
                livingEntity.damage(1.0);
            }
            XSound.ENTITY_WARDEN_AGITATED.play(location);
            bukkitTask.cancel();
        }, 60L);
        if (n < 4) {
            Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> ParticleDisplay.of(XParticle.FLAME).withCount(30).offset(0.1).spawn(LocationUtils.getHandLocation((LivingEntity)player, false)), 20L);
        }
    }

    @EventHandler
    public void onSkillActivate(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_AIR && playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        Integer n = (Integer)PERFECT_JUDGEMENT_CUTS.getIfPresent((Object)player.getUniqueId());
        if (n == null) {
            return;
        }
        if (n == 4) {
            XSound.ENTITY_WARDEN_EMERGE.play(player.getLocation());
            PERFECT_JUDGEMENT_CUTS.invalidate((Object)player.getUniqueId());
        } else {
            PERFECT_JUDGEMENT_CUTS.put((Object)player.getUniqueId(), (Object)(n + 1));
        }
    }
}

