/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vergil;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.utils.NPCHandler;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class VergilDoppelganger
extends ActiveAbility {
    public VergilDoppelganger() {
        super("Vergil", "doppelganger");
        this.setPvPBased(true);
    }

    @Override
    public boolean isSupported() {
        try {
            Class.forName("net.citizensnpcs.api.npc.NPC");
            Class.forName("org.mcmonkey.sentinel.SentinelTrait");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!this.isSupported()) {
            player.sendMessage("You can't use this ability because Citizens and Sentinel are not installed.");
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.CLOUD).withCount(100).offset(2.0);
        particleDisplay.spawn(player.getLocation());
        NPCHandler.spawnNPC(player, livingEntity);
    }
}

