/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.types.SkillScaling;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class VampireBloodLust
extends Ability {
    public VampireBloodLust() {
        super("Vampire", "blood_lust");
    }

    @EventHandler(ignoreCancelled=true)
    public void onVampireHeal(EntityRegainHealthEvent entityRegainHealthEvent) {
        double d;
        if (entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (!(entityRegainHealthEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityRegainHealthEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d2 = skilledPlayer.getEnergy();
        int n = (int)MathUtils.getPercent(d2, d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY));
        if ((double)n < this.getScaling(skilledPlayer, "energy", new Object[0])) {
            return;
        }
        entityRegainHealthEvent.setAmount(entityRegainHealthEvent.getAmount() + this.getScaling(skilledPlayer, "regain", new Object[0]));
    }

    @EventHandler(ignoreCancelled=true)
    public void onVampireAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d2 = skilledPlayer.getEnergy();
        int n = (int)MathUtils.getPercent(d2, d = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY));
        if ((double)n < this.getScaling(skilledPlayer, "energy", entityDamageByEntityEvent)) {
            return;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent));
        if (skilledPlayer.getAbilityLevel(this) > 2 && MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
            VersionSupport.heal((LivingEntity)player, this.getScaling(skilledPlayer, "heal", entityDamageByEntityEvent));
            ParticleDisplay.colored(player.getLocation(), 20, 255, 0, 1.0f).spawn();
        }
    }
}

