/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.EntityEffect;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.DamageManager;
import org.skills.utils.Laser;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class VampireBloodCircuit
extends ActiveAbility {
    private static final String MINION = "VAMPIRE_VEX";

    public VampireBloodCircuit() {
        super("vampire", "blood_circuit");
    }

    private static void killMinion(LivingEntity livingEntity) {
        ParticleDisplay.of(XParticle.CLOUD).withLocation(livingEntity.getLocation()).withCount(100).offset(0.5).withExtra(0.05).spawn();
        livingEntity.setHealth(0.0);
    }

    private static Vex spawnMinion(Player player, LivingEntity livingEntity) {
        Vex vex = (Vex)player.getWorld().spawnEntity(player.getLocation(), EntityType.VEX);
        vex.setTarget(livingEntity);
        if (XMaterial.supports(13)) {
            vex.setCharging(true);
        }
        vex.setMetadata(MINION, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)livingEntity));
        vex.setRemoveWhenFarAway(true);
        vex.setCustomName(MessageHandler.colorize("&c" + player.getName() + " Minion"));
        vex.setCustomNameVisible(true);
        return vex;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVampireCircuit(final EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (livingEntity.getHealth() - entityDamageByEntityEvent.getFinalDamage() < 1.0) {
            return;
        }
        Player player2 = (Player)entityDamageByEntityEvent.getDamager();
        final SkilledPlayer skilledPlayer = this.checkup(player2);
        if (skilledPlayer == null) {
            return;
        }
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            player.playEffect(EntityEffect.GUARDIAN_TARGET);
        }
        player = (EnderCrystal)player2.getWorld().spawnEntity(player2.getLocation().add(0.0, 2.0, 0.0), XEntityType.END_CRYSTAL.get());
        player.setShowingBottom(false);
        XSound.ENTITY_ELDER_GUARDIAN_CURSE.play(player.getLocation());
        boolean bl = false;
        Laser laser = null;
        if (bl) {
            try {
                laser = new Laser(player.getLocation().add(0.0, 0.5, 0.0), () -> livingEntity.getEyeLocation().add(0.0, -0.75, 0.0), -1, 16);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            laser.start((Plugin)SkillsPro.get());
        }
        Laser laser2 = laser;
        int n = skilledPlayer.getAbilityLevel(this);
        new BukkitRunnable((EnderCrystal)player, bl, laser2, n, player2){
            final double damageMod;
            final int inferno;
            final double distance;
            final Set<LivingEntity> minions;
            final ParticleDisplay particle;
            double damage;
            int duration;
            int repeat;
            int particleTimer;
            final /* synthetic */ EnderCrystal val$crystal;
            final /* synthetic */ boolean val$useLaser;
            final /* synthetic */ Laser val$finalLaser;
            final /* synthetic */ int val$lvl;
            final /* synthetic */ Player val$player;
            {
                this.val$crystal = enderCrystal;
                this.val$useLaser = bl;
                this.val$finalLaser = laser;
                this.val$lvl = n;
                this.val$player = player;
                this.damageMod = VampireBloodCircuit.this.getScaling(skilledPlayer, "damage-modifier", entityDamageByEntityEvent);
                this.inferno = (int)VampireBloodCircuit.this.getScaling(skilledPlayer, "inferno", entityDamageByEntityEvent);
                this.distance = VampireBloodCircuit.this.getScaling(skilledPlayer, "distance", entityDamageByEntityEvent);
                this.minions = new HashSet<LivingEntity>();
                this.particle = ParticleDisplay.of(XParticle.DRAGON_BREATH).withLocation(null).withCount(10).offset(0.1);
                this.damage = VampireBloodCircuit.this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent);
                this.duration = (int)(VampireBloodCircuit.this.getScaling(skilledPlayer, "duration", entityDamageByEntityEvent) * 20.0);
                this.repeat = 0;
                this.particleTimer = 0;
            }

            public void run() {
                boolean bl;
                if (!livingEntity.isValid() || !this.val$crystal.isValid() || this.duration-- <= 0) {
                    this.cancel();
                    if (this.val$useLaser) {
                        this.val$finalLaser.stop();
                    }
                    ParticleDisplay.of(XParticle.WITCH).withLocation(this.val$crystal.getLocation()).withCount(200).offset(0.5).withExtra(0.5).spawn();
                    this.val$crystal.remove();
                    for (LivingEntity livingEntity2 : this.minions) {
                        VampireBloodCircuit.killMinion(livingEntity2);
                    }
                    return;
                }
                boolean bl2 = bl = livingEntity.getLocation().distance(this.val$crystal.getLocation()) > this.distance;
                if (bl) {
                    return;
                }
                if (this.particleTimer++ == 10) {
                    this.particleTimer = 0;
                    if (!this.val$useLaser) {
                        Particles.line(this.val$crystal.getLocation().add(0.0, 0.5, 0.0), livingEntity.getEyeLocation(), 0.2, this.particle);
                    }
                }
                if (this.repeat++ == this.inferno) {
                    this.repeat = 0;
                    DamageManager.damage(livingEntity, null, this.damage);
                    if (this.val$lvl > 1) {
                        VersionSupport.heal((LivingEntity)this.val$player, this.damage);
                    }
                    this.damage += this.damageMod;
                    if (this.val$lvl > 2) {
                        this.minions.add((LivingEntity)VampireBloodCircuit.spawnMinion(this.val$player, livingEntity));
                    }
                    if (this.val$useLaser) {
                        this.val$finalLaser.callColorChange();
                    }
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 1L, 1L);
    }

    @EventHandler
    public void onTargetChange(EntityTargetEvent entityTargetEvent) {
        if (!XMaterial.supports(11)) {
            return;
        }
        if (entityTargetEvent.getEntity().getType() != EntityType.VEX) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        List list = entity.getMetadata(MINION);
        if (list.isEmpty()) {
            return;
        }
        Entity entity2 = (Entity)((MetadataValue)list.get(0)).value();
        if (entityTargetEvent.getTarget() != entity2) {
            entityTargetEvent.setTarget(entity2);
        }
    }
}

