/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.vampire;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class VampireBleed
extends Ability {
    public VampireBleed() {
        super("Vampire", "bleed");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVampireAttack(final EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        final Player player = (Player)entityDamageByEntityEvent.getDamager();
        final SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
            return;
        }
        final ParticleDisplay particleDisplay = ParticleDisplay.colored(player.getLocation(), 0, 255, 0, 1.0f).withCount(30).offset(0.5);
        final ParticleDisplay particleDisplay2 = ParticleDisplay.colored(player.getLocation(), 255, 0, 0, 1.0f).withCount(30).offset(0.5);
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        new BukkitRunnable(){
            final double damageHeal;
            int duration;
            {
                this.damageHeal = VampireBleed.this.getScaling(skilledPlayer, "damage-heal", entityDamageByEntityEvent);
                this.duration = (int)VampireBleed.this.getScaling(skilledPlayer, "duration", entityDamageByEntityEvent);
            }

            public void run() {
                if (!livingEntity.isValid()) {
                    this.cancel();
                    return;
                }
                particleDisplay.spawn(player.getLocation());
                particleDisplay2.spawn(livingEntity.getLocation());
                livingEntity.damage(this.damageHeal);
                VersionSupport.heal((LivingEntity)player, this.damageHeal);
                if (this.duration-- <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 10L);
    }
}

