/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;

public class SwordsmanThousandCuts
extends ActiveAbility {
    private static final Map<Integer, Integer> activeTrapcount = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> thousandcuts = new HashMap<Integer, Integer>();
    private static final Map<Integer, Location> activeLocation = new HashMap<Integer, Location>();

    public SwordsmanThousandCuts() {
        super("Swordsman", "thousand_cuts");
    }

    @EventHandler(ignoreCancelled=true)
    public void onSwordsmanAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        final Player player = (Player)entityDamageByEntityEvent.getDamager();
        Integer n = thousandcuts.get(player.getEntityId());
        final SkilledPlayer skilledPlayer = n == null ? this.checkup(player) : SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer == null) {
            return;
        }
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        int n2 = skilledPlayer.getAbilityLevel(this);
        if (n != null && n.intValue() == livingEntity.getEntityId()) {
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent));
            Color color = n2 == 1 ? Color.CYAN : (n2 == 2 ? Color.ORANGE : Color.RED);
            ParticleDisplay particleDisplay = ParticleDisplay.colored(null, color.getRed(), color.getGreen(), color.getBlue(), 1.0f);
            for (int i = MathUtils.randInt(1, n2 + 2); i > 0; --i) {
                Location location = livingEntity.getEyeLocation().add(MathUtils.rand(-3.0, 3.0), MathUtils.rand(-0.5, 2.0), MathUtils.rand(-3.0, 3.0));
                Vector vector = livingEntity.getEyeLocation().subtract(location).toVector().multiply(MathUtils.rand(1.2, 1.8));
                Location location2 = location.clone().add(vector);
                Particles.line(location, location2, 0.1, particleDisplay);
            }
        }
        thousandcuts.put(player.getEntityId(), entityDamageByEntityEvent.getEntity().getEntityId());
        activeTrapcount.put(livingEntity.getEntityId(), 0);
        activeLocation.put(livingEntity.getEntityId(), livingEntity.getLocation());
        new BukkitRunnable(){

            public void run() {
                Integer n = activeTrapcount.getOrDefault(livingEntity.getEntityId(), null);
                if (n == null) {
                    return;
                }
                if ((double)n.intValue() < SwordsmanThousandCuts.this.getScaling(skilledPlayer, "cut-count", new Object[0]) && livingEntity.isValid()) {
                    activeTrapcount.put(livingEntity.getEntityId(), n + 1);
                    Location location = (Location)activeLocation.get(livingEntity.getEntityId());
                    Location location2 = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), (float)MathUtils.randInt(0, 360), (float)MathUtils.randInt(-90, 90));
                    livingEntity.teleport(location2);
                } else {
                    thousandcuts.remove(player.getEntityId());
                    activeTrapcount.remove(livingEntity.getEntityId());
                    activeLocation.remove(livingEntity.getEntityId());
                    SwordsmanThousandCuts.this.sendMessage(player, SwordsmanThousandCuts.this.getAbilityFinished(skilledPlayer), new Object[0]);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 5L);
    }
}

