/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.EntityUtil;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XEnchantment;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.XTag;
import org.skills.utils.xseries.particles.XParticle;
import org.skills.utils.xseries.reflection.XReflection;
import org.skills.utils.xseries.reflection.minecraft.NMSExtras;

public class SwordsmanPassive
extends Ability {
    public static final Map<Integer, EntityDamageByEntityEvent> OFFHAND = new HashMap<Integer, EntityDamageByEntityEvent>();

    public SwordsmanPassive() {
        super("Swordsman", "passive");
    }

    protected static boolean isSword(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        return SwordsmanPassive.isSword(XMaterial.matchXMaterial(itemStack));
    }

    protected static boolean isSword(XMaterial xMaterial) {
        switch (xMaterial) {
            case NETHERITE_SWORD: 
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                return true;
            }
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onOffhandInvalidate(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        OFFHAND.remove(entityDamageByEntityEvent.getEntity().getEntityId());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        OFFHAND.remove(playerQuitEvent.getPlayer().getEntityId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onSwordsmanAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        if (!SwordsmanPassive.isSword(player)) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent));
    }

    @EventHandler
    public void onDuelWieldInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() != EquipmentSlot.OFF_HAND) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            Player player = playerInteractEvent.getPlayer();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
            if (!XTag.anyMatchString(xMaterial, this.getOptions(skilledPlayer, "weapons").getStringList())) {
                return;
            }
            NMSExtras.animation(player.getWorld().getPlayers(), (LivingEntity)player, NMSExtras.Animation.SWING_OFF_HAND);
            if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR && this.getOptions(skilledPlayer, "cooldown").getBoolean()) {
                int n = (int)(1.0 / player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).getValue() * 20.0);
                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> player.setCooldown(itemStack.getType(), n));
            }
        });
    }

    @EventHandler
    public void onDuelWieldAttack(PlayerInteractEntityEvent playerInteractEntityEvent) {
        boolean bl;
        if (playerInteractEntityEvent.getHand() != EquipmentSlot.OFF_HAND) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.isInvulnerable() || !livingEntity.isValid()) {
            return;
        }
        if (livingEntity instanceof Player && ((Player)livingEntity).getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (livingEntity.getNoDamageTicks() > livingEntity.getMaximumNoDamageTicks() / 2) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInOffHand();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
        if (!XTag.anyMatchString(xMaterial, this.getOptions(skilledPlayer, "weapons").getStringList())) {
            return;
        }
        double d = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue();
        int n = itemStack.getEnchantmentLevel(XEnchantment.SHARPNESS.getEnchant());
        if (n != 0) {
            d += 0.5 * (double)(n - 1) + 1.0;
        }
        double d2 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR).getValue();
        double d3 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS).getValue();
        d *= 1.0 - Math.min(20.0, Math.max(d2 / 5.0, d2 - d / (2.0 + d3 / 4.0))) / 25.0;
        NMSExtras.animation(player.getWorld().getPlayers(), (LivingEntity)player, NMSExtras.Animation.SWING_OFF_HAND);
        EntityDamageByEntityEvent entityDamageByEntityEvent = XReflection.supports(20, 5) ? new EntityDamageByEntityEvent((Entity)player, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, DamageSource.builder((DamageType)DamageType.PLAYER_ATTACK).withCausingEntity((Entity)player).withDirectEntity((Entity)player).build(), d) : new EntityDamageByEntityEvent((Entity)player, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, d);
        Bukkit.getPluginManager().callEvent((Event)entityDamageByEntityEvent);
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        OFFHAND.put(entity.getEntityId(), entityDamageByEntityEvent);
        livingEntity.damage(entityDamageByEntityEvent.getDamage());
        int n2 = 0;
        if (this.getOptions(skilledPlayer, "cooldown").getBoolean()) {
            double d4;
            n2 = player.getCooldown(itemStack.getType());
            if (n2 != 0) {
                d /= (double)n2;
            }
            if ((d4 = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).getValue()) >= 20.0) {
                player.setCooldown(itemStack.getType(), (int)(20.0 - d4));
            }
        }
        boolean bl2 = bl = n2 == 0 && !player.isSprinting();
        if (bl) {
            int n3 = itemStack.getEnchantmentLevel(XEnchantment.SWEEPING_EDGE.getEnchant());
            int n4 = 1;
            if (n3 != 0) {
                n4 = (int)((double)n4 + MathUtils.percentOfAmount(50 + (n3 - 1) * 25, d));
            }
            for (Entity entity2 : livingEntity.getNearbyEntities(1.0, 1.0, 1.0)) {
                if (entity2.getEntityId() == player.getEntityId() || EntityUtil.isInvalidEntity(entity2)) continue;
                LivingEntity livingEntity2 = (LivingEntity)entity2;
                livingEntity2.damage((double)n4, (Entity)player);
            }
        }
        if (bl) {
            player.spawnParticle(XParticle.SWEEP_ATTACK.get(), entity.getLocation().clone().add(0.0, 0.75, 0.0), 1);
            XSound.ENTITY_PLAYER_ATTACK_SWEEP.play(player.getLocation());
        }
        player.spawnParticle(XParticle.DAMAGE_INDICATOR.get(), entity.getLocation().clone().add(0.0, 0.75, 0.5), MathUtils.randInt(1, 4), 0.1, 0.1, 1.0, 0.2);
        if (itemStack.getDurability() + 1 < itemStack.getType().getMaxDurability()) {
            itemStack.setDurability((short)(itemStack.getDurability() + 1));
        } else {
            XSound.ENTITY_ITEM_BREAK.play(player.getLocation());
            player.getInventory().setItemInOffHand(null);
        }
        double d5 = (double)itemStack.getEnchantmentLevel(XEnchantment.KNOCKBACK.getEnchant()) + 0.5;
        Vector vector = player.getLocation().getDirection().add(new Vector(0.0, 0.7, 0.0)).multiply(d5);
        entity.setVelocity(vector);
        int n5 = itemStack.getEnchantmentLevel(XEnchantment.FIRE_ASPECT.getEnchant());
        if (n5 != 0) {
            entity.setFireTicks(n5 * 80);
        }
    }
}

