/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.swordsman;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class SwordsmanDash
extends InstantActiveAbility {
    public SwordsmanDash() {
        super("Swordsman", "dash");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        final SkilledPlayer skilledPlayer = abilityContext.getInfo();
        new BukkitRunnable(){
            final ParticleDisplay display = ParticleDisplay.of(XParticle.CLOUD).withLocation(null).withCount(10).offset(0.5, 0.2, 0.5);
            int repeat = 20;

            public void run() {
                this.display.spawn(player.getLocation());
                if (--this.repeat == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        int n = skilledPlayer.getAbilityLevel(this);
        if (n >= 3) {
            new BukkitRunnable(){
                final List<PotionEffect> effects;
                final double range;
                final double kb;
                final double damage;
                final ParticleDisplay masterDisplay;
                final Set<Integer> targets;
                int repeat;
                {
                    this.effects = SwordsmanDash.this.getEffects(skilledPlayer, "effects");
                    this.range = SwordsmanDash.this.getScaling(skilledPlayer, "range", new Object[0]);
                    this.kb = SwordsmanDash.this.getScaling(skilledPlayer, "knockback", new Object[0]);
                    this.damage = SwordsmanDash.this.getScaling(skilledPlayer, "damage", new Object[0]);
                    this.masterDisplay = ParticleDisplay.of(XParticle.SWEEP_ATTACK).withLocation(null).withCount(10).offset(1.0);
                    this.targets = new HashSet<Integer>();
                    this.repeat = 20;
                }

                public void run() {
                    for (Entity entity : player.getNearbyEntities(this.range, this.range, this.range)) {
                        if (EntityUtil.filterEntity(player, entity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (!this.targets.add(entity.getEntityId())) continue;
                        livingEntity.addPotionEffects(this.effects);
                        livingEntity.setVelocity(livingEntity.getVelocity().subtract(player.getVelocity()).multiply(this.kb));
                        livingEntity.damage(this.damage, (Entity)player);
                        Location location = livingEntity.getLocation();
                        XSound.ENTITY_PLAYER_ATTACK_SWEEP.play(location, 3.0f, 1.0f);
                        this.masterDisplay.spawn(location);
                    }
                    if ((this.repeat -= 2) == 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 2L);
        }
        int n2 = (int)this.getScaling(skilledPlayer, "vertical-slash-level", new Object[0]);
        Vector vector = player.getLocation().getDirection();
        Vector vector2 = new Vector(vector.getX(), n >= n2 ? vector.getY() : 0.0, vector.getZ()).normalize();
        double d = this.getScaling(skilledPlayer, "velocity", new Object[0]);
        player.setVelocity(vector2.multiply(d));
    }
}

