/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.concurrent.TimeUnit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.Cooldown;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.XParticle;

public class PriestSealOfLife
extends Ability {
    private static final String SEAL_OF_LIFE = "SEAL_OF_LIFE";

    public PriestSealOfLife() {
        super("Priest", "seal_of_life");
    }

    private static Location generateRandomCoords(Location location) {
        double d;
        double d2;
        double d3;
        Location location2;
        Block block;
        do {
            d3 = MathUtils.randInt(20, 50);
            d2 = MathUtils.randInt(20, 50);
            d = MathUtils.randInt(20, 50);
        } while ((block = (location2 = location.clone().add(d3, d2, d)).getBlock()).getType().name().endsWith("AIR") || block.getRelative(BlockFace.UP).getType().name().endsWith("AIR"));
        Block block2 = block.getRelative(BlockFace.DOWN);
        return location2;
    }

    @EventHandler(ignoreCancelled=true)
    public void onNearDeathEscape(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        final Player player = (Player)entityDamageByEntityEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!Cooldown.isInCooldown(player.getUniqueId(), SEAL_OF_LIFE)) {
            int n = VersionSupport.getHealthPercent((LivingEntity)player, (EntityDamageEvent)entityDamageByEntityEvent);
            if ((double)n > this.getScaling(skilledPlayer, "health", entityDamageByEntityEvent)) {
                return;
            }
            entityDamageByEntityEvent.setCancelled(true);
            if (XMaterial.supports(11)) {
                player.playEffect(EntityEffect.TOTEM_RESURRECT);
            }
            this.applyEffects(skilledPlayer, (LivingEntity)player);
            new BukkitRunnable(){
                int i = 30;

                public void run() {
                    player.spawnParticle(XParticle.HAPPY_VILLAGER.get(), player.getLocation(), 50, 1.0, 1.0, 1.0, 0.0);
                    if (--this.i == 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
            new Cooldown(player.getUniqueId(), SEAL_OF_LIFE, (long)this.getScaling(skilledPlayer, "interval", new Object[0]), TimeUnit.SECONDS);
        }
    }
}

