/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.api.events.ClassChangeEvent;
import org.skills.api.events.SkillToggleAbilityEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.resurrect.LastBreath;
import org.skills.utils.LocationUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.XParticle;
import org.skills.utils.xseries.reflection.XReflection;

public class PriestPassive
extends Ability {
    private static final Set<Integer> JESUS = new HashSet<Integer>();

    public PriestPassive() {
        super("Priest", "passive");
    }

    private static void disableFly(Player player) {
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!JESUS.remove(player.getEntityId())) {
            return;
        }
        player.setAllowFlight(false);
        player.setFlying(false);
    }

    @Override
    public void start() {
        PriestPassive.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkilledPlayer skilledPlayer;
                    World.Environment environment = player.getWorld().getEnvironment();
                    if (environment == World.Environment.NORMAL || !(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player)).hasAbility(PriestPassive.this)) continue;
                    if (environment == World.Environment.NETHER) {
                        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> PriestPassive.this.applyEffects(skilledPlayer, "effects.nether", (LivingEntity)player));
                        XSound.ENTITY_WITHER_AMBIENT.play((Entity)player);
                        continue;
                    }
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> PriestPassive.this.applyEffects(skilledPlayer, "effects.end", (LivingEntity)player));
                    XSound.ENTITY_ENDER_DRAGON_AMBIENT.play((Entity)player);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 100L, (long)this.getOptions("Priest", "interval").getInt() * 20L));
    }

    private static boolean isWaterLogged(Block block) {
        if (XReflection.supports(13)) {
            if (block.getBlockData() instanceof Waterlogged) {
                Waterlogged waterlogged = (Waterlogged)block.getBlockData();
                return waterlogged.isWaterlogged();
            }
            Material material = block.getType();
            switch (material) {
                case SEA_PICKLE: 
                case SEAGRASS: 
                case TALL_SEAGRASS: {
                    return true;
                }
            }
            if (material.name().contains("CORAL")) {
                return true;
            }
        }
        return block.getType().name().endsWith("WATER");
    }

    @EventHandler(ignoreCancelled=true)
    public void jesus(PlayerMoveEvent playerMoveEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            if (!LocationUtils.hasMoved(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
                return;
            }
            Player player = playerMoveEvent.getPlayer();
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            if (LastBreath.isLastBreaths(player)) {
                return;
            }
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (!this.getOptions(skilledPlayer, "jesus").getBoolean()) {
                return;
            }
            Block block = player.getLocation().getBlock();
            if (XReflection.supports(16) && player.isInWater() || PriestPassive.isWaterLogged(block) || PriestPassive.isWaterLogged(block.getRelative(BlockFace.DOWN))) {
                if (player.getAllowFlight()) {
                    player.spawnParticle(XParticle.CLOUD.get(), player.getLocation(), 5, 0.1, 0.1, 0.1, 0.1);
                    return;
                }
                if (!player.isFlying()) {
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                        player.setAllowFlight(true);
                        player.setFlying(true);
                        JESUS.add(player.getEntityId());
                        player.setVelocity(player.getLocation().getDirection().setY(0.1));
                    });
                }
                player.spawnParticle(XParticle.CLOUD.get(), player.getLocation(), 30, 0.3, 0.0, 0.3, 0.3);
            } else {
                if (!player.getAllowFlight()) {
                    return;
                }
                if (!JESUS.remove(player.getEntityId())) {
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                });
            }
        });
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (JESUS.remove(player.getEntityId())) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (JESUS.remove(player.getEntityId())) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPassiveDisable(SkillToggleAbilityEvent skillToggleAbilityEvent) {
        if (!skillToggleAbilityEvent.isDisabled()) {
            return;
        }
        if (!skillToggleAbilityEvent.getAbility().getName().endsWith("passive")) {
            return;
        }
        if (!skillToggleAbilityEvent.getInfo().getSkillName().equalsIgnoreCase("priest")) {
            return;
        }
        PriestPassive.disableFly(skillToggleAbilityEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPassiveDisable(ClassChangeEvent classChangeEvent) {
        if (!classChangeEvent.getInfo().getSkillName().equals(this.getSkill())) {
            return;
        }
        Player player = classChangeEvent.getInfo().getPlayer();
        if (player == null) {
            return;
        }
        PriestPassive.disableFly(player);
    }

    @EventHandler
    public void lavaEscape(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.LAVA) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        final Player player = (Player)entityDamageEvent.getEntity();
        if (LastBreath.isLastBreaths(player)) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityDamageEvent.setCancelled(true);
        player.setFireTicks(0);
        Vector vector = new Vector(-player.getEyeLocation().getDirection().getX(), 1.5, -player.getEyeLocation().getDirection().getZ());
        player.setVelocity(vector);
        XSound.ENTITY_GENERIC_EXTINGUISH_FIRE.play((Entity)player);
        new BukkitRunnable(){
            int i = 5;

            public void run() {
                player.spawnParticle(XParticle.FLAME.get(), player.getLocation(), 10, 0.01, 0.01, 0.01, 0.1);
                --this.i;
                if (this.i == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
    }
}

