/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class PriestNaturesCall
extends ActiveAbility {
    private static final String MINION = "PRIEST_NATURES_CALL";
    private static final String DAMAGE = "PRIEST_NATURES_DAMAGE";
    private static final Map<UUID, Set<Entity>> MINIONS = new HashMap<UUID, Set<Entity>>();

    public PriestNaturesCall() {
        super("Arbalist", "natures_call");
    }

    private static void killMinion(LivingEntity livingEntity) {
        livingEntity.getLocation().getWorld().spawnParticle(XParticle.DRAGON_BREATH.get(), livingEntity.getLocation(), 100, 0.5, 0.5, 0.5, 0.05);
        livingEntity.setHealth(0.0);
    }

    @EventHandler
    public void onTargetChange(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getEntityType() != EntityType.WOLF) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        List list = entity.getMetadata(MINION);
        if (list.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)((MetadataValue)list.get(0)).value();
        if (entityTargetEvent.getTarget() == null || !livingEntity.getUniqueId().equals(entityTargetEvent.getTarget().getUniqueId())) {
            entityTargetEvent.setTarget((Entity)livingEntity);
        }
    }

    @EventHandler
    public void onMinionTargetDeath(EntityDeathEvent entityDeathEvent) {
        Set<Entity> set = MINIONS.get(entityDeathEvent.getEntity().getUniqueId());
        if (set != null) {
            for (Entity entity : set) {
                if (!entity.isValid() || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                PriestNaturesCall.killMinion(livingEntity);
            }
        }
        if (entityDeathEvent.getEntity().hasMetadata(MINION)) {
            entityDeathEvent.getEntity().getLocation().getWorld().spawnParticle(XParticle.DRAGON_BREATH.get(), entityDeathEvent.getEntity().getLocation(), 100, 0.5, 0.5, 0.5, 0.05);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMinionAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getDamager();
        List list = livingEntity.getMetadata(DAMAGE);
        if (list.isEmpty()) {
            return;
        }
        double d = ((MetadataValue)list.get(0)).asDouble();
        entityDamageByEntityEvent.setDamage(d);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        final Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        Location location = player.getLocation();
        new BukkitRunnable(){
            int times = 10;

            public void run() {
                XSound.ENTITY_FOX_AGGRO.play((Entity)player);
                --this.times;
                if (this.times == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
        HashSet<Wolf> hashSet = new HashSet<Wolf>();
        double d = this.getScaling(skilledPlayer, "damage", new Object[0]);
        for (int i = (int)this.getScaling(skilledPlayer, "minions", new Object[0]); i > 0; --i) {
            int n = MathUtils.randInt(1, 3);
            int n2 = MathUtils.randInt(1, 3);
            Location location2 = location.clone().add((double)n, 0.0, (double)n2);
            if (!location2.getBlock().getType().name().endsWith("AIR")) {
                location2 = player.getLocation();
            }
            ParticleDisplay.of(XParticle.LARGE_SMOKE).withLocation(location2).withCount(100).offset(0.5, 0.5, 0.5).spawn();
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            if (!entity.isValid()) {
                atomicBoolean.set(true);
                return;
            }
            Location location3 = location2.setDirection(entity.getLocation().toVector().subtract(location2.toVector()));
            Wolf wolf = (Wolf)location2.getWorld().spawnEntity(location3, EntityType.WOLF);
            wolf.setMetadata(MINION, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)entity));
            wolf.setMetadata(DAMAGE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)d));
            wolf.setTarget((LivingEntity)entity);
            wolf.setRemoveWhenFarAway(true);
            wolf.setCustomName(MessageHandler.colorize("&c" + player.getName() + " Wolf"));
            wolf.setCustomNameVisible(true);
            this.applyEffects(skilledPlayer, (LivingEntity)wolf);
            this.applyEffects(skilledPlayer, (LivingEntity)player);
            hashSet.add(wolf);
            if (atomicBoolean.get()) break;
        }
        MINIONS.put(entity.getUniqueId(), hashSet);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            for (Entity entity : hashSet) {
                if (!entity.isValid()) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                PriestNaturesCall.killMinion(livingEntity);
            }
        }, (long)(this.getScaling(skilledPlayer, "time", new Object[0]) * 20.0));
    }
}

