/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.particles.XParticle;

public class PriestMindPossession
extends Ability {
    public PriestMindPossession() {
        super("Priest", "mind_possession");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamageParalyze(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>(3);
        int n = skilledPlayer.getAbilityLevel(this);
        arrayList.add(XPotion.BLINDNESS.buildPotionEffect(n * 5 * 20, 1));
        if (n > 1) {
            arrayList.add(XPotion.SLOWNESS.buildPotionEffect(n * 5 * 20, 1));
            player.spawnParticle(XParticle.ENTITY_EFFECT.get(), livingEntity.getEyeLocation(), 30, 0.3, 0.0, 0.3, 0.3);
        }
        livingEntity.addPotionEffects(arrayList);
    }
}

