/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class PriestKindlingOfLife
extends InstantActiveAbility {
    private static final String SPELL = "PRIEST_SPELL";

    public PriestKindlingOfLife() {
        super("Priest", "kindling_of_life");
        this.setPvPBased(false);
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        int n = skilledPlayer.getAbilityLevel(this);
        if (player.isSneaking()) {
            XSound.ENTITY_GENERIC_DRINK.play(player.getLocation());
            ParticleDisplay.of(XParticle.HEART).withLocation(player.getLocation()).withCount(n * 20).offset(0.5, 0.5, 0.5).spawn();
            VersionSupport.heal((LivingEntity)player, this.getScaling(skilledPlayer, "heal", new Object[0]));
            return;
        }
        Vector vector = player.getEyeLocation().getDirection().multiply(n * 2);
        final Projectile projectile = player.launchProjectile(ThrownPotion.class, vector);
        projectile.setMetadata(SPELL, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)n));
        XSound.ENTITY_SPLASH_POTION_THROW.play((Entity)player);
        new BukkitRunnable(){
            int i = 5;

            public void run() {
                ParticleDisplay.of(XParticle.HEART).withCount(10).offset(0.01).withExtra(0.1).spawn(projectile.getLocation());
                if (--this.i == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
        XSound.ITEM_FIRECHARGE_USE.play((Entity)player);
    }

    @EventHandler
    public void spellHit(ProjectileHitEvent projectileHitEvent) {
        Entity entity = projectileHitEvent.getHitEntity();
        if (entity == null || this.isInvalidTarget(entity)) {
            return;
        }
        ProjectileSource projectileSource = projectileHitEvent.getEntity().getShooter();
        if (projectileSource == null) {
            return;
        }
        if (!projectileHitEvent.getEntity().hasMetadata(SPELL)) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)projectileSource));
        LivingEntity livingEntity = (LivingEntity)entity;
        XSound.ENTITY_EXPERIENCE_ORB_PICKUP.play((Entity)projectileSource, 2.0f, 0.0f);
        entity.getWorld().spawnParticle(XParticle.HEART.get(), entity.getLocation(), 30, 0.5, 0.5, 0.5, 0.5);
        List<PotionEffect> list = entity instanceof Player ? this.getEffects(skilledPlayer, "effects") : this.getEffects(skilledPlayer, "debuffs");
        ((LivingEntity)entity).addPotionEffects(list);
        VersionSupport.heal(livingEntity, this.getScaling(skilledPlayer, "heal", new Object[0]));
    }
}

