/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.Cooldown;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class PriestBarrier
extends InstantActiveAbility {
    public PriestBarrier() {
        super("Priest", "barrier");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        final SkilledPlayer skilledPlayer = abilityContext.getInfo();
        skilledPlayer.setActiveAbilitiy(this, true);
        final double d = this.getScaling(skilledPlayer, "duration", new Object[0]);
        int n = (int)this.getScaling(skilledPlayer, "frequency", new Object[0]);
        final double d2 = 1.0 / (20.0 / (double)n);
        final double d3 = this.getScaling(skilledPlayer, "radius", new Object[0]);
        this.playSound(player, skilledPlayer, "start");
        PriestBarrier.disposableTask(player, new BukkitRunnable(){
            final ParticleDisplay barrier;
            final double count;
            double repeat;
            {
                this.barrier = ParticleDisplay.of(XParticle.PORTAL).withEntity((Entity)player);
                this.count = Math.min(d3 * 5.0, 50.0);
                this.repeat = d;
            }

            public void run() {
                double d4;
                Particles.sphere(d3, this.count, this.barrier);
                PriestBarrier.this.playSound(player, skilledPlayer, "end");
                this.repeat -= d2;
                if (d4 <= 0.0) {
                    this.cancel();
                    skilledPlayer.setActiveAbilitiy(PriestBarrier.this, false);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 10L));
        PriestBarrier.disposableTask(player, new BukkitRunnable(){
            final List<PotionEffect> effects;
            final List<PotionEffect> friendlyEffects;
            final double kb;
            final double damage;
            double repeat;
            {
                this.effects = PriestBarrier.this.getEffects(skilledPlayer, "effects");
                this.friendlyEffects = PriestBarrier.this.getEffects(skilledPlayer, "friendly-effects");
                this.kb = PriestBarrier.this.getScaling(skilledPlayer, "knockback", new Object[0]);
                this.damage = PriestBarrier.this.getScaling(skilledPlayer, "damage", new Object[0]);
                this.repeat = d;
            }

            public void run() {
                double d4;
                for (Entity entity : player.getNearbyEntities(d3, d3, d3)) {
                    if (EntityUtil.isInvalidEntity(entity) || Cooldown.isInCooldown(entity.getEntityId(), "PRIEST_BARRIER")) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (ServiceHandler.areFriendly((Entity)player, entity)) {
                        livingEntity.addPotionEffects(this.friendlyEffects);
                        continue;
                    }
                    if (this.damage != 0.0) {
                        livingEntity.damage(this.damage, (Entity)player);
                    }
                    livingEntity.addPotionEffects(this.effects);
                    if (this.kb != 0.0) {
                        livingEntity.setVelocity(EntityUtil.validateExcessiveVelocity(entity.getLocation().toVector().subtract(player.getLocation().toVector()).multiply(this.kb)));
                    }
                    PriestBarrier.this.playSound(player, skilledPlayer, "barrier");
                    new Cooldown(entity.getEntityId(), "PRIEST_BARRIER", 5L, TimeUnit.SECONDS);
                }
                this.repeat -= d2;
                if (d4 <= 0.0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, (long)n));
    }
}

