/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.priest;

import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.abilities.priest.PriestPurification;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class PriestAsclepius
extends InstantActiveAbility {
    public PriestAsclepius() {
        super("Priest", "asclepius");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        int n = skilledPlayer.getAbilityLevel(this);
        PriestPurification.spreadFlower(player, (int)this.getScaling(skilledPlayer, "spread-flower-chance", new Object[0]), 3);
        double d = this.getScaling(skilledPlayer, "damage", new Object[0]);
        double d2 = this.getScaling(skilledPlayer, "range", new Object[0]);
        List list = player.getNearbyEntities(d2, d2, d2);
        list.add(player);
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player2 = (Player)entity;
            if (ServiceHandler.areFriendly((Entity)player, entity)) {
                this.applyEffects(skilledPlayer, (LivingEntity)player2);
                XSound.ENTITY_GENERIC_DRINK.play(entity);
                player2.getWorld().spawnParticle(XParticle.WITCH.get(), player2.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
                if (n <= 2) continue;
                for (PotionEffect potionEffect : player2.getActivePotionEffects()) {
                    if (!XPotion.DEBUFFS.contains((Object)XPotion.matchXPotion(potionEffect.getType()))) continue;
                    player2.removePotionEffect(potionEffect.getType());
                }
                continue;
            }
            if (!(d > 0.0)) continue;
            player2.getWorld().spawnParticle(XParticle.LAVA.get(), player2.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
            player2.damage(d);
        }
        XSound.ITEM_TOTEM_USE.play((Entity)player);
        XSound.ENTITY_BAT_TAKEOFF.play((Entity)player);
        Particles.circle(d2 * 2.0, d2 * 8.0, ParticleDisplay.of(XParticle.LARGE_SMOKE).withLocation(player.getLocation()));
        if (n > 1) {
            Particles.helix((Plugin)SkillsPro.get(), n + 1, 1.5, 0.05, 1.0, 6.0, 3.0, 0.5, true, false, ParticleDisplay.of(XParticle.ENCHANT).withLocation(player.getLocation()));
        }
    }
}

