/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.types.SkillScaling;
import org.skills.utils.xseries.XMaterial;

public class MagePassive
extends Ability {
    public MagePassive() {
        super("Mage", "passive");
    }

    public static boolean isHoe(ItemStack itemStack) {
        return MagePassive.isHoe(XMaterial.matchXMaterial(itemStack));
    }

    public static boolean isHoe(XMaterial xMaterial) {
        switch (xMaterial) {
            case NETHERITE_HOE: 
            case DIAMOND_HOE: 
            case GOLDEN_HOE: 
            case IRON_HOE: 
            case WOODEN_HOE: {
                return true;
            }
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        if (!MagePassive.isHoe(player.getItemInHand())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        ConfigurationSection configurationSection = this.getOptions(skilledPlayer, "hoe-damage").getSection();
        XMaterial xMaterial = XMaterial.matchXMaterial(player.getItemInHand());
        double d = this.getAbsoluteScaling(skilledPlayer, configurationSection.getString(xMaterial.name()), "damage", entityDamageByEntityEvent.getDamage());
        int n = (int)this.getScaling(skilledPlayer, "energy", new Object[0]);
        skilledPlayer.setEnergy(Math.min(skilledPlayer.getEnergy() + (double)n, skilledPlayer.getScaling(SkillScaling.MAX_ENERGY)));
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
    }
}

