/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.MoveManager;
import org.skills.utils.Cooldown;
import org.skills.utils.MathUtils;
import org.skills.utils.ParticleUtil;
import org.skills.utils.xseries.XEnchantment;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class MageNeptune
extends Ability {
    private static final String NEPTUNE = "NEPTUNE";
    private static final String NEPTUNE_AERIAL = "NEPTUNE_AERIAL";
    private static final String NEPTUNE_JUMP_FALL_DAMAGE = "NEPTUNE_FALL";
    private static final String NEPTUNE_MINION = "NEPTUNE_MINION";
    private static final Cache<UUID, Location> SAFE_LOCATION_FIX = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    public MageNeptune() {
        super("Mage", "neptune");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTridentHit(ProjectileHitEvent projectileHitEvent) {
        Block block;
        if (projectileHitEvent.getEntity().hasMetadata(NEPTUNE_MINION)) {
            XSound.ITEM_TRIDENT_RETURN.record().withPitch(2.0f).soundPlayer().atLocation(projectileHitEvent.getEntity().getLocation()).play();
            Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                ParticleUtil.cloudParticle(projectileHitEvent.getEntity().getLocation());
                projectileHitEvent.getEntity().remove();
            }, 300L);
        }
        if (!(projectileHitEvent.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectileHitEvent.getEntity().getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getAbilityLevel(this) < 3) {
            return;
        }
        if (!projectileHitEvent.getEntity().hasMetadata(NEPTUNE)) {
            return;
        }
        if (projectileHitEvent.getHitBlock() != null) {
            block = projectileHitEvent.getHitBlock();
            SAFE_LOCATION_FIX.put((Object)player.getUniqueId(), (Object)block.getRelative(projectileHitEvent.getHitBlockFace()).getLocation());
        }
        if (projectileHitEvent.getEntity() instanceof Trident && (block = (Trident)projectileHitEvent.getEntity()).getItem().containsEnchantment(XEnchantment.LOYALTY.getEnchant())) {
            projectileHitEvent.getEntity().removePassenger(projectileHitEvent.getEntity().getPassenger());
        }
        if (!MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chances.lightning", new Object[0]))) {
            return;
        }
        block = projectileHitEvent.getEntity().getLocation();
        LightningStrike lightningStrike = block.getWorld().strikeLightning((Location)block);
        lightningStrike.setMetadata(NEPTUNE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player));
        new Cooldown(player.getUniqueId(), NEPTUNE, 10L, TimeUnit.SECONDS);
        XSound.ITEM_TRIDENT_THUNDER.record().withPitch(0.1f).soundPlayer().atLocation((Location)block).play();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPick(PlayerPickupArrowEvent playerPickupArrowEvent) {
        if (playerPickupArrowEvent.getArrow().hasMetadata(NEPTUNE)) {
            playerPickupArrowEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onTridentLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        if (!XMaterial.supports(13)) {
            return;
        }
        Projectile projectile = projectileLaunchEvent.getEntity();
        if (!(projectile instanceof Trident)) {
            return;
        }
        final Trident trident = (Trident)projectile;
        ProjectileSource projectileSource = trident.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getAbilityLevel(this) < 3) {
            return;
        }
        if (player.getInventory().getItemInOffHand().getType() == Material.TRIDENT && player.isSneaking()) {
            AtomicInteger atomicInteger;
            List list = player.getMetadata(NEPTUNE_AERIAL);
            if (list.isEmpty()) {
                atomicInteger = new AtomicInteger(0);
                player.setMetadata(NEPTUNE_AERIAL, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)atomicInteger));
            } else {
                atomicInteger = (AtomicInteger)((MetadataValue)list.get(0)).value();
            }
            int n = (int)this.getScaling(skilledPlayer, "aerial-limit", new Object[0]);
            if (atomicInteger.addAndGet(1) > n) {
                XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
                projectileLaunchEvent.setCancelled(true);
                return;
            }
            player.setSneaking(false);
            trident.addPassenger((Entity)player);
            trident.setMetadata(NEPTUNE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player));
            XSound.ITEM_TRIDENT_RIPTIDE_3.record().withPitch(0.1f).soundPlayer().atLocation(trident.getLocation()).play();
            new BukkitRunnable(){
                int tenTickTimer = 10;
                final ParticleDisplay particle = ParticleDisplay.of(XParticle.DUST).withColor(Color.CYAN, 1.0f).offset(0.3, 0.3, 0.3).withCount(10).withEntity((Entity)trident);

                public void run() {
                    if (--this.tenTickTimer <= 0) {
                        this.tenTickTimer = 10;
                    }
                    if (!trident.isValid()) {
                        this.cancel();
                    }
                    this.particle.spawn();
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 1L, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDismount(EntityDismountEvent entityDismountEvent) {
        Entity entity = entityDismountEvent.getDismounted();
        if (entity.hasMetadata(NEPTUNE)) {
            Trident trident = (Trident)entity;
            if (entityDismountEvent.getEntity() instanceof Player) {
                final Player player = (Player)entityDismountEvent.getEntity();
                new Cooldown(player.getUniqueId(), NEPTUNE_JUMP_FALL_DAMAGE, 20L, TimeUnit.SECONDS);
                SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
                int n = skilledPlayer.getAbilityLevel(this);
                boolean bl = false;
                if ((double)n >= this.getScaling(skilledPlayer, "jump.required-level", new Object[0])) {
                    bl = true;
                    double d = this.getScaling(skilledPlayer, "jump.height", new Object[0]);
                    player.setVelocity(player.getLocation().getDirection().normalize().multiply(-1).setY(d));
                }
                final CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
                if ((double)n >= this.getScaling(skilledPlayer, "minion-trident.required-level", new Object[0]) && !Cooldown.isInCooldown(player.getUniqueId(), NEPTUNE_MINION)) {
                    bl = true;
                    new Cooldown(player.getUniqueId(), NEPTUNE_MINION, (long)this.getScaling(skilledPlayer, "minion-trident.cooldown", new Object[0]), TimeUnit.SECONDS);
                    XSound.ITEM_TRIDENT_RETURN.record().withPitch(0.0f).soundPlayer().atLocation(player.getLocation()).play();
                    Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                        int n = (int)this.getScaling(skilledPlayer, "minion-trident.trident-amount", new Object[0]);
                        boolean bl = MathUtils.isEven(n);
                        int n2 = (int)Math.floor((double)n / 2.0);
                        ArrayList<Double> arrayList = new ArrayList<Double>(n);
                        if (!bl) {
                            arrayList.add(0.0);
                        }
                        for (int i = 1; i <= n2; ++i) {
                            double d = n <= 3 ? 20.0 : (n <= 5 ? 10.0 : 5.0);
                            d = i == 1 && bl ? (d /= 2.0) : (d *= (double)i);
                            arrayList.add(Math.toRadians(d));
                            arrayList.add(-Math.toRadians(d));
                        }
                        for (Double d : arrayList) {
                            Vector vector = player.getLocation().getDirection().normalize();
                            Vector vector2 = ParticleUtil.getPerpendicularVector(vector);
                            Vector vector3 = ParticleDisplay.Quaternion.rotate(vector, ParticleDisplay.Quaternion.rotation(d, vector2));
                            Trident trident = (Trident)player.getWorld().spawnEntity(player.getEyeLocation().clone().add(vector.multiply(0.5)), EntityType.TRIDENT);
                            trident.setVelocity(vector3);
                            trident.setMetadata(NEPTUNE_MINION, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player));
                            copyOnWriteArrayList.add(trident);
                        }
                    }, 5L);
                }
                if (bl) {
                    new BukkitRunnable(){
                        int ticks = 100;
                        final ParticleDisplay particle = ParticleDisplay.of(XParticle.DUST).withColor(Color.RED, 1.0f).offset(0.3, 0.3, 0.3).withCount(10).withEntity((Entity)player);

                        public void run() {
                            if (--this.ticks <= 0) {
                                this.cancel();
                            }
                            if (copyOnWriteArrayList.isEmpty()) {
                                this.particle.spawn();
                            } else {
                                for (Trident trident : copyOnWriteArrayList) {
                                    if (!trident.isValid()) {
                                        this.cancel();
                                        return;
                                    }
                                    this.particle.spawn(trident.getLocation());
                                }
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 1L, 1L);
                }
                if (player.getGameMode() != GameMode.CREATIVE) {
                    PlayerInventory playerInventory = player.getInventory();
                    if (playerInventory.getItemInOffHand().getType() == Material.AIR) {
                        playerInventory.setItemInOffHand(trident.getItem());
                    } else {
                        HashMap hashMap = playerInventory.addItem(new ItemStack[]{trident.getItem()});
                        if (!hashMap.isEmpty()) {
                            return;
                        }
                    }
                }
            }
            entity.remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTridentLightningFire(EntityDamageEvent entityDamageEvent) {
        UUID uUID = entityDamageEvent.getEntity().getUniqueId();
        switch (entityDamageEvent.getCause()) {
            case FIRE_TICK: 
            case FIRE: 
            case FALL: {
                break;
            }
            case SUFFOCATION: {
                Location location = (Location)SAFE_LOCATION_FIX.getIfPresent((Object)uUID);
                if (location == null) break;
                entityDamageEvent.getEntity().teleport(location);
                SAFE_LOCATION_FIX.invalidate((Object)uUID);
                break;
            }
            default: {
                return;
            }
        }
        if (Cooldown.isInCooldown(uUID, NEPTUNE)) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTridentHitLightning(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof LightningStrike)) {
            return;
        }
        List list = entityDamageByEntityEvent.getDamager().getMetadata(NEPTUNE);
        if (list.isEmpty()) {
            return;
        }
        Player player = (Player)((MetadataValue)list.get(0)).value();
        if (entityDamageByEntityEvent.getEntity() == player) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTrident(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!XMaterial.supports(13)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Trident)) {
            return;
        }
        ProjectileSource projectileSource = ((Trident)entityDamageByEntityEvent.getDamager()).getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)projectileSource;
        final SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent));
        final LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chances.lightning", entityDamageByEntityEvent))) {
            player.getWorld().strikeLightning(livingEntity.getLocation());
        }
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chances.multiply", entityDamageByEntityEvent))) {
            new BukkitRunnable(){
                int repeat;
                {
                    this.repeat = (int)MageNeptune.this.getScaling(skilledPlayer, "multiply", new Object[0]);
                }

                public void run() {
                    if (!livingEntity.isValid()) {
                        this.cancel();
                    }
                    Location location = livingEntity.getLocation().clone().add(0.0, 10.0, 0.0);
                    int n = MathUtils.randInt(0, 10);
                    int n2 = MathUtils.randInt(0, 10);
                    Location location2 = location.clone().add((double)n, 0.0, (double)n2);
                    Location location3 = livingEntity.getEyeLocation();
                    Vector vector = location3.toVector().subtract(location2.toVector());
                    location.getWorld().spawnParticle(XParticle.CLOUD.get(), location2, 100, 0.5, 0.5, 0.5, 0.0);
                    Trident trident = (Trident)location.getWorld().spawnEntity(location2, EntityType.TRIDENT);
                    trident.setVelocity(vector.multiply(0.5));
                    if (this.repeat-- <= 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 10L, 10L);
        }
    }

    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chances_lightning%", this.getScalingDescription(skilledPlayer, this.getOptions(skilledPlayer).getString("chances.lightning")), "%chances_multiply%", this.getScalingDescription(skilledPlayer, this.getOptions(skilledPlayer).getString("chances.multiply")), "%multiply%", this.getScalingDescription(skilledPlayer, this.getOptions(skilledPlayer).getString("multiply"))};
    }

    static {
        MoveManager.registerPlayerHitGround(player -> {
            List list = player.getMetadata(NEPTUNE_AERIAL);
            if (!list.isEmpty()) {
                AtomicInteger atomicInteger = (AtomicInteger)((MetadataValue)list.get(0)).value();
                atomicInteger.set(0);
            }
        });
    }
}

