/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class MageChronoprohiberis
extends InstantActiveAbility {
    private static final String META = "Chronoprohiberis";

    public MageChronoprohiberis() {
        super("Mage", "chronoprohiberis");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        HashSet<LivingEntity> hashSet = new HashSet<LivingEntity>();
        double d = this.getScaling(skilledPlayer, "range", new Object[0]);
        int n = (int)this.getScaling(skilledPlayer, "duration", new Object[0]) * 20;
        double d2 = this.getScaling(skilledPlayer, "damage", new Object[0]);
        List<PotionEffect> list = this.getEffects(skilledPlayer, "effects");
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.LARGE_SMOKE).withCount(50).offset(0.5);
        Set<EntityType> set = this.getEntityList(skilledPlayer, "blacklisted");
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            if (EntityUtil.filterEntity(player, entity) || set.contains(entity.getType())) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            hashSet.add(livingEntity);
            livingEntity.setMetadata(META, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
            if (!(livingEntity instanceof Player)) {
                livingEntity.setAI(false);
            }
            livingEntity.damage(d2, (Entity)player);
            livingEntity.addPotionEffects(list);
            particleDisplay.spawn(livingEntity.getEyeLocation());
            XSound.ENCHANT_THORNS_HIT.play((Entity)livingEntity, 3.0f, 0.5f);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        particleDisplay.withParticle(XParticle.CLOUD);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            for (LivingEntity livingEntity : hashSet) {
                livingEntity.removeMetadata(META, (Plugin)SkillsPro.get());
                if (!(livingEntity instanceof Player)) {
                    livingEntity.setAI(true);
                }
                particleDisplay.spawn(livingEntity.getEyeLocation());
                XSound.BLOCK_BEACON_DEACTIVATE.play((Entity)livingEntity);
            }
        }, (long)n);
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.getPlayer().hasMetadata(META)) {
            playerMoveEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimation(PlayerAnimationEvent playerAnimationEvent) {
        if (playerAnimationEvent.getPlayer().hasMetadata(META)) {
            playerAnimationEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSneak(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.getPlayer().hasMetadata(META)) {
            playerToggleSneakEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.getPlayer().hasMetadata(META)) {
            blockBreakEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.getPlayer().hasMetadata(META)) {
            blockPlaceEvent.setCancelled(true);
        }
    }
}

