/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;

public class JuggernautStoneSkin
extends Ability {
    public JuggernautStoneSkin() {
        super("Juggernaut", "stone_skin");
    }

    @EventHandler(ignoreCancelled=true)
    public void onJuggernautDefend(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        ConfigurationSection configurationSection = this.getOptions(skilledPlayer, "protections").getSection();
        if (configurationSection == null) {
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            Optional optional = Enums.getIfPresent(EntityDamageEvent.DamageCause.class, (String)string.toUpperCase(Locale.ENGLISH));
            if (!optional.isPresent() || entityDamageEvent.getCause() != optional.get()) continue;
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() - this.getAbsoluteScaling(skilledPlayer, configurationSection.getString(string), "damage", entityDamageEvent.getDamage()));
            break;
        }
    }
}

