/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.DamageManager;
import org.skills.utils.EntityUtil;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class JuggernautChainSmash
extends InstantActiveAbility {
    private static final String CHAIN_SMASH = "CHAIN_SMASH";

    public JuggernautChainSmash() {
        super("Juggernaut", "chain_smash");
    }

    private static void explosionWave(JavaPlugin javaPlugin, final double d, final ParticleDisplay particleDisplay, final ParticleDisplay particleDisplay2) {
        new BukkitRunnable(){
            final double addition = 0.3141592653589793;
            final double rateDiv = Math.PI / d;
            double times = 0.7853981633974483;

            public void run() {
                this.times += 0.3141592653589793;
                for (double d5 = 0.0; d5 <= Math.PI * 2; d5 += this.rateDiv) {
                    double d2 = this.times * Math.cos(d5);
                    double d3 = 2.0 * Math.exp(-0.1 * this.times) * Math.sin(this.times) + 1.5;
                    double d4 = this.times * Math.sin(d5);
                    particleDisplay.spawn(d2, d3, d4);
                    d2 = this.times * Math.cos(d5 += 0.04908738521234052);
                    d4 = this.times * Math.sin(d5);
                    particleDisplay2.spawn(d2, d3, d4);
                }
                if (this.times > 20.0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 0L, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void tntDmaage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof TNTPrimed)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!entity.hasMetadata(CHAIN_SMASH)) {
            return;
        }
        Player player = (Player)((MetadataValue)entity.getMetadata(CHAIN_SMASH).get(0)).value();
        if (player == entityDamageByEntityEvent.getEntity()) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFall(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (!SkilledPlayer.getSkilledPlayer((OfflinePlayer)entityDamageEvent.getEntity()).getActiveAbilities().remove(this)) {
            return;
        }
        entityDamageEvent.setCancelled(true);
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        final SkilledPlayer skilledPlayer = abilityContext.getInfo();
        skilledPlayer.setActiveAbilitiy(this, true);
        double d = this.getScaling(skilledPlayer, "initial-launch", new Object[0]);
        player.setVelocity(new Vector(0.0, d, 0.0));
        XSound.ENTITY_HORSE_JUMP.play((Entity)player, 3.0f, 0.0f);
        final ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.CLOUD).withLocation(player.getLocation()).withCount(100).offset(1.0);
        particleDisplay.spawn();
        final double d2 = this.getScaling(skilledPlayer, "damage", new Object[0]);
        final double d3 = this.getScaling(skilledPlayer, "range", new Object[0]);
        final double d4 = this.getScaling(skilledPlayer, "explosion-launch", new Object[0]);
        double d5 = this.getScaling(skilledPlayer, "smash-force", new Object[0]);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            player.setVelocity(new Vector(0.0, d5, 0.0));
            new BukkitRunnable(){

                public void run() {
                    Object object;
                    if (player.isFlying()) {
                        return;
                    }
                    Location location = player.getLocation();
                    if (!MathUtils.isInteger(location.getY())) {
                        return;
                    }
                    this.cancel();
                    particleDisplay.spawn(location);
                    if (!JuggernautChainSmash.this.getOptions(skilledPlayer, "disable-explosion").getBoolean()) {
                        object = (TNTPrimed)player.getWorld().spawnEntity(location, XEntityType.TNT.get());
                        object.setMetadata(JuggernautChainSmash.CHAIN_SMASH, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player));
                        object.setFuseTicks(0);
                    }
                    XSound.ENTITY_GENERIC_EXPLODE.play((Entity)player, (float)d3, 1.0f);
                    object = ParticleDisplay.of(XParticle.EXPLOSION_EMITTER.get()).withCount(10).offset(1.0);
                    JuggernautChainSmash.explosionWave(SkillsPro.get(), 20.0, ParticleDisplay.of(XParticle.FIREWORK).withLocation(location), ParticleDisplay.of(XParticle.WITCH).withLocation(location));
                    for (Entity entity : player.getNearbyEntities(d3, d3, d3)) {
                        if (EntityUtil.filterEntity(player, entity)) continue;
                        DamageManager.damage((LivingEntity)entity, player, d2);
                        entity.setVelocity(new Vector(0.0, d4, 0.0));
                        ((ParticleDisplay)object).spawn(entity.getLocation());
                    }
                    skilledPlayer.setActiveAbilitiy(JuggernautChainSmash.this, false);
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 5L, 1L);
        }, 20L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTp(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getLastAbilityUsed() != this) {
            return;
        }
        SkillsLang.COMMAND_BINDINGS_CHANGED.sendMessage(player, new Object[0]);
    }
}

