/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import java.util.concurrent.TimeUnit;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.DamageManager;
import org.skills.utils.Cooldown;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class JuggernautAegisProtection
extends Ability {
    private static final String AEGIS = "JUGGERNAUT_AEGIS";

    public JuggernautAegisProtection() {
        super("Juggernaut", "aegis_protection");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onJuggernautDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ParticleDisplay particleDisplay;
        Entity entity;
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof EnderPearl) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (Cooldown.isInCooldown(player.getUniqueId(), AEGIS)) {
            return;
        }
        long l = (long)this.getScaling(skilledPlayer, "cooldown", new Object[0]);
        new Cooldown(player.getUniqueId(), AEGIS, l, TimeUnit.SECONDS);
        entityDamageByEntityEvent.setCancelled(true);
        int n = skilledPlayer.getAbilityLevel(this);
        player.getLocation().getWorld().spawnParticle(XParticle.LARGE_SMOKE.get(), player.getLocation(), 30, 1.0, 1.0, 1.0, 0.3);
        XSound.ENTITY_ITEM_BREAK.play((Entity)player);
        if (n > 1) {
            entity = entityDamageByEntityEvent.getDamager();
            if (entity instanceof Projectile && (entity = (Entity)((Projectile)entity).getShooter()) == null) {
                entity = entityDamageByEntityEvent.getDamager();
            }
            XSound.ENTITY_GENERIC_EXPLODE.play((Entity)player);
            particleDisplay = ParticleDisplay.of(XParticle.FLAME).withLocation(entity.getLocation()).offset(1.0);
            if (entity instanceof LivingEntity) {
                double d = MathUtils.percentOfAmount(this.getScaling(skilledPlayer, "reflect-damage-percent", entityDamageByEntityEvent), entityDamageByEntityEvent.getDamage());
                DamageManager.damage((LivingEntity)entity, player, d);
            }
        }
        if (n > 2 && (double)VersionSupport.getHealthPercent((LivingEntity)player) < this.getScaling(skilledPlayer, "knockback.health", entityDamageByEntityEvent)) {
            entity = entityDamageByEntityEvent.getDamager();
            particleDisplay = entity.getLocation().toVector().subtract(player.getLocation().toVector());
            entity.setVelocity(particleDisplay.multiply(this.getScaling(skilledPlayer, "knockback.velocity", entityDamageByEntityEvent)));
        }
        SkillsLang.Skill_Juggernaut_Aegis_Success.sendMessage(player, new Object[0]);
    }
}

