/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.abilities.mage.MagePassive;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.utils.Cooldown;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.XTag;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;
import org.skills.utils.xseries.reflection.XReflection;

public class FireMagePhoenixEssence
extends InstantActiveAbility {
    private static final Map<Integer, AtomicBoolean> ACITVATED;
    private static final Team GLOW_TEAM;
    private static final boolean SUPPORTS_GLOW;
    private static final boolean SUPPORTS_PERSISTENCE;
    private static final Set<XMaterial> IGNITE_MATERIALS;

    public FireMagePhoenixEssence() {
        super("FireMage", "phoenix_essence");
    }

    public static void forwardSlash(final double d, final ParticleDisplay particleDisplay) {
        new BukkitRunnable(){
            double limit = 0.0;
            private final Location loc = particleDisplay.getLocation().clone();

            public void run() {
                for (double d4 = 0.0; d4 <= Math.PI; d4 += 0.10471975511965977) {
                    double d2 = 3.0 * Math.cos(d4);
                    double d3 = 3.0 * Math.sin(d4);
                    Vector vector = new Vector(d2, 0.0, d3);
                    Location location = particleDisplay.getLocation().clone();
                    ParticleDisplay.Quaternion quaternion = ParticleDisplay.Quaternion.rotation(this.loc.getYaw(), new Vector(0, 1, 0));
                    quaternion = quaternion.mul(ParticleDisplay.Quaternion.rotation(-this.loc.getPitch(), new Vector(1, 0, 0)));
                    quaternion = quaternion.mul(ParticleDisplay.Quaternion.rotation(45.0, new Vector(0, 0, 1)));
                    Vector vector2 = ParticleDisplay.Quaternion.rotate(vector, quaternion);
                    location = location.add(vector2);
                    particleDisplay.spawn(location);
                }
                double d5 = this.limit;
                this.limit = d5 + 1.0;
                if (d5 >= d) {
                    this.cancel();
                } else {
                    particleDisplay.advanceInDirection(0.1);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 1L, 1L);
    }

    public static BukkitTask volcano(final int n, long l, final double d, final ParticleDisplay particleDisplay) {
        return new BukkitRunnable(){
            final ThreadLocalRandom random = ThreadLocalRandom.current();
            int count = n;

            public void run() {
                particleDisplay.offset(this.random.nextDouble(-d, d), this.random.nextDouble(0.5, 1.0), this.random.nextDouble(-d, d)).spawn();
                if (this.count-- <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, l);
    }

    private static void thunderTunnel(final Location location, final double d, final Runnable runnable) {
        new BukkitRunnable(){
            int count = 5;

            public void run() {
                Particles.circle(0.7, 30.0, ParticleDisplay.of(XParticle.FLAME).withLocation(location.add(0.0, d, 0.0)).directional().withExtra(0.07).offset(0.0, 0.0, -0.03));
                float f = 1.0f;
                if (this.count-- == 0) {
                    this.cancel();
                    f = 2.0f;
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), runnable);
                }
                XSound.BLOCK_CONDUIT_DEACTIVATE.or(XSound.ENTITY_ENDERMAN_TELEPORT).record().withVolume(10.0f).withPitch(f).soundPlayer().atLocation(location).play();
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        final Player player = playerInteractEvent.getPlayer();
        AtomicBoolean atomicBoolean = ACITVATED.get(player.getEntityId());
        if (atomicBoolean == null) {
            return;
        }
        if (!MagePassive.isHoe(player.getInventory().getItemInMainHand())) {
            return;
        }
        final SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        int n = skilledPlayer.getAbilityLevel(this);
        if (playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR && (double)n >= this.getScaling(skilledPlayer, "levels.slash", new Object[0])) {
            if (Cooldown.isInCooldown(player.getUniqueId(), "FIREMAGE_SLASH")) {
                return;
            }
            ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.SOUL_FIRE_FLAME.or(XParticle.FLAME)).withLocation(player.getEyeLocation());
            AtomicInteger atomicInteger = new AtomicInteger();
            double d = Math.toRadians(45.0);
            if (atomicBoolean.getAndSet(!atomicBoolean.get())) {
                d = -d;
                new Cooldown(player.getUniqueId(), "FIREMAGE_SLASH", (long)this.getScaling(skilledPlayer, "cooldown.slash", new Object[0]), TimeUnit.SECONDS);
            }
            double d2 = this.getScaling(skilledPlayer, "damage.slash", new Object[0]);
            particleDisplay.face((Entity)player).rotate(0.0, 0.0, d).postCalculation(calculationContext -> {
                if (atomicInteger.incrementAndGet() == 5) {
                    atomicInteger.set(0);
                    Location location = calculationContext.getLocation();
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                        for (Entity entity : location.getWorld().getNearbyEntities(location, 0.5, 0.5, 0.5)) {
                            if (EntityUtil.filterEntity(player, entity)) continue;
                            DamageManager.damage((LivingEntity)entity, player, d2);
                        }
                    });
                }
            });
            FireMagePhoenixEssence.forwardSlash(this.getScaling(skilledPlayer, "distance.slash", new Object[0]), particleDisplay);
            this.playSound(player, skilledPlayer, "slash");
        } else if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR && (double)n >= this.getScaling(skilledPlayer, "levels.volcano", new Object[0])) {
            if (Cooldown.isInCooldown(player.getUniqueId(), "FIREMAGE_VOLCANO")) {
                return;
            }
            new Cooldown(player.getUniqueId(), "FIREMAGE_VOLCANO", (long)this.getScaling(skilledPlayer, "cooldown.volcano", new Object[0]), TimeUnit.SECONDS);
            final Location location = player.getLocation();
            final double d = this.getScaling(skilledPlayer, "radius.volcano", new Object[0]);
            new BukkitRunnable(){
                static final double radius = 1.0;
                final double maxDistance;
                final double throwForce;
                final Vector directionIgnorePitch;
                final double lastY;
                final Vector zipZag;
                double distance;
                boolean odd;
                {
                    this.maxDistance = FireMagePhoenixEssence.this.getScaling(skilledPlayer, "distance.volcano", new Object[0]);
                    this.throwForce = FireMagePhoenixEssence.this.getScaling(skilledPlayer, "knockback.volcano", new Object[0]);
                    this.directionIgnorePitch = location.getDirection().setY(0).normalize();
                    this.lastY = location.getY();
                    this.zipZag = ParticleDisplay.rotateAround(this.directionIgnorePitch.clone(), ParticleDisplay.Axis.Y, 1.5707963267948966);
                    this.distance = 1.0;
                }

                public void run() {
                    double d4;
                    this.odd = !this.odd;
                    double d2 = 1.0 * (double)(this.odd ? -1 : 1);
                    double d3 = FireMagePhoenixEssence.this.getScaling(skilledPlayer, "damage.volcano", new Object[0]);
                    Location location3 = location.clone().add(this.directionIgnorePitch.clone().multiply(this.distance)).add(this.zipZag.clone().multiply(d2));
                    location3.setY(this.lastY);
                    Block block = null;
                    for (int i = 8; i > 0; --i) {
                        block = location3.getBlock();
                        if (IGNITE_MATERIALS.contains((Object)XMaterial.matchXMaterial(block.getType()))) break;
                        block = null;
                        location3 = i == 8 ? location3.add(0.0, -4.0, 0.0) : location3.add(0.0, 1.0, 0.0);
                    }
                    FireMagePhoenixEssence.volcano(20, 1L, 0.1, ParticleDisplay.of(XParticle.FLAME).withLocation(location3).directional().withExtra(1.0));
                    ParticleDisplay.of(XParticle.LAVA).withLocation(location3).directional().withExtra(1.0).spawn();
                    FireMagePhoenixEssence.this.playSound(player, skilledPlayer, "volcano");
                    Block block2 = block;
                    Location location2 = location3;
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                        if (block2 != null) {
                            block2.setType(Material.FIRE);
                        }
                        for (Entity entity : player.getWorld().getNearbyEntities(location2, d, d, d)) {
                            if (EntityUtil.filterEntity(player, entity)) continue;
                            entity.setFireTicks(100);
                            entity.setVelocity(new Vector(0.0, this.throwForce, 0.0));
                            DamageManager.damage((LivingEntity)entity, player, d3);
                        }
                    });
                    this.distance += 2.0;
                    if (d4 >= this.maxDistance) {
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 3L);
        }
    }

    @Override
    public void useSkill(final AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        this.playSound(player, abilityContext.getInfo(), "music");
        new BukkitRunnable(){
            static final double rand = 10.0;
            final ThreadLocalRandom random = ThreadLocalRandom.current();
            int count = 100;

            public void run() {
                Location location = player.getLocation().add(this.random.nextDouble(-10.0, 10.0), this.random.nextDouble(-1.0, 10.0), this.random.nextDouble(-10.0, 10.0));
                ParticleDisplay.of(XParticle.FLAME).withCount(30).offset(5.0).withLocation(location).spawn();
                if (this.count-- == 0) {
                    this.cancel();
                    ACITVATED.put(player.getEntityId(), new AtomicBoolean());
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> FireMagePhoenixEssence.this.start(abilityContext));
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 1L, 1L);
    }

    private void start(AbilityContext abilityContext) {
        Object object2;
        final Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        int n = skilledPlayer.getAbilityLevel(this);
        double d = this.getScaling(skilledPlayer, "radius.initial", new Object[0]);
        final double d2 = this.getScaling(skilledPlayer, "radius.lightning", new Object[0]);
        double d3 = this.getScaling(skilledPlayer, "damage.initial", new Object[0]);
        double d4 = this.getScaling(skilledPlayer, "knockback.initial", new Object[0]);
        Particles.sphere(3.0, 40.0, ParticleDisplay.of(XParticle.SOUL_FIRE_FLAME.or(XParticle.FLAME)).withLocation(player.getLocation()).directional().withExtra(0.5).offset(0.5));
        Location location = player.getLocation();
        for (Object object2 : player.getNearbyEntities(d, d, d)) {
            if (EntityUtil.filterEntity(player, object2)) continue;
            if (object2 instanceof Player) {
                ParticleDisplay.of(XParticle.FLASH).withLocation(null).onlyVisibleTo((Player)object2).spawn(object2.getLocation());
            }
            DamageManager.damage((LivingEntity)object2, player, d3);
            EntityUtil.knockBack(object2, location, d4);
        }
        XSound.ENTITY_WARDEN_ROAR.or(XSound.ENTITY_SKELETON_HORSE_DEATH).play(location);
        final SkeletonHorse skeletonHorse = (SkeletonHorse)player.getWorld().spawnEntity(player.getLocation(), EntityType.SKELETON_HORSE);
        skeletonHorse.setJumpStrength(3.0);
        skeletonHorse.getInventory().setSaddle(XMaterial.SADDLE.parseItem());
        skeletonHorse.setPassenger((Entity)player);
        skeletonHorse.setInvulnerable(true);
        skeletonHorse.setRemoveWhenFarAway(true);
        if (SUPPORTS_PERSISTENCE) {
            skeletonHorse.setPersistent(false);
        }
        skeletonHorse.setFireTicks(100000);
        skeletonHorse.setArrowsInBody(10);
        if (SUPPORTS_GLOW) {
            skeletonHorse.setGlowing(true);
            GLOW_TEAM.setColor(ChatColor.DARK_RED);
            GLOW_TEAM.addEntry(skeletonHorse.getUniqueId().toString());
        }
        skeletonHorse.setDomestication(skeletonHorse.getMaxDomestication());
        skeletonHorse.setOwner((AnimalTamer)player);
        skeletonHorse.setTamed(true);
        this.applyEffects(skilledPlayer, "horse-effects", (LivingEntity)skeletonHorse);
        object2 = (double)n >= this.getScaling(skilledPlayer, "levels.lightning", new Object[0]) ? new BukkitRunnable(){

            public void run() {
                for (Entity entity : player.getNearbyEntities(d2, d2, d2)) {
                    if (entity == skeletonHorse || EntityUtil.filterEntity(player, entity)) continue;
                    if (entity instanceof Player) {
                        ParticleDisplay.of(XParticle.FLASH).withLocation(null).onlyVisibleTo((Player)entity).spawn(entity.getLocation());
                    }
                    entity.setFireTicks(200);
                    Location location = entity.getLocation();
                    FireMagePhoenixEssence.thunderTunnel(location.clone(), 1.0, () -> {
                        entity.getWorld().strikeLightning(location);
                        XSound.ENTITY_LIGHTNING_BOLT_THUNDER.play(location);
                    });
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 100L, 100L) : null;
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> this.lambda$start$2(player, (BukkitTask)object2, skeletonHorse, skilledPlayer, location), (long)(this.getScaling(skilledPlayer, "duration", new Object[0]) * 20.0));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!ACITVATED.containsKey(entityDamageEvent.getEntity().getEntityId())) {
            return;
        }
        Particles.circle(2.0, 30.0, ParticleDisplay.of(XParticle.FLAME).directional().withExtra(1.0).withLocation(entityDamageEvent.getEntity().getLocation()));
        entityDamageEvent.setCancelled(true);
    }

    private /* synthetic */ void lambda$start$2(Player player, BukkitTask bukkitTask, SkeletonHorse skeletonHorse, SkilledPlayer skilledPlayer, Location location) {
        ACITVATED.remove(player.getEntityId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        skeletonHorse.setHealth(0.0);
        XSound.Record record = this.getSound(skilledPlayer, "music");
        if (record != null) {
            float f = record.getVolume();
            for (Entity entity : location.getWorld().getNearbyEntities(location, (double)f, (double)f, (double)f)) {
                if (!(entity instanceof Player)) continue;
                record.soundPlayer().forPlayers((Player)entity).stopSound();
            }
        }
        this.playSound(player, skilledPlayer, "end");
    }

    static {
        Scoreboard scoreboard;
        Team team;
        ACITVATED = new HashMap<Integer, AtomicBoolean>();
        SUPPORTS_GLOW = XReflection.of(Entity.class).method("void setGlowing(boolean glowing);").exists();
        SUPPORTS_PERSISTENCE = XReflection.of(Entity.class).method("void setPersistent(boolean persistent);").exists();
        IGNITE_MATERIALS = EnumSet.of(XMaterial.TALL_GRASS, XMaterial.SHORT_GRASS);
        IGNITE_MATERIALS.addAll(XTag.AIR.getValues());
        IGNITE_MATERIALS.addAll(XTag.FLOWERS.getValues());
        FireMagePhoenixEssence.addDisposableHandler(ACITVATED);
        GLOW_TEAM = SUPPORTS_GLOW ? ((team = (scoreboard = Bukkit.getScoreboardManager().getMainScoreboard()).getTeam("SkillsProPhoenixEss")) == null ? scoreboard.registerNewTeam("SkillsProPhoenixEss") : team) : null;
    }
}

