/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class FireMageMeteorite
extends InstantActiveAbility {
    private static final String METEORITE = "METEORITE";

    public FireMageMeteorite() {
        super("FireMage", "meteorite");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        List list;
        Location location;
        Block block;
        Player player = abilityContext.getPlayer();
        final SkilledPlayer skilledPlayer = abilityContext.getInfo();
        if (XMaterial.supports(13)) {
            block = player.getTargetBlockExact(20);
        } else {
            location = EnumSet.of(Material.AIR, XMaterial.TALL_GRASS.parseMaterial());
            list = player.getLineOfSight(location, 20);
            block = (Block)list.get(list.size() - 1);
        }
        location = block == null ? player.getLocation().clone().add(player.getLocation().getDirection().multiply(20)) : block.getLocation();
        list = location.clone().add(0.0, 5.0, 0.0);
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.FLAME).withLocation(null).withCount(10);
        ParticleDisplay particleDisplay2 = ParticleDisplay.of(XParticle.EXPLOSION).withLocation(null).withCount(10).offset(1.0, 1.0, 1.0);
        new BukkitRunnable((Location)list, threadLocalRandom, location, player, particleDisplay, particleDisplay2){
            final float yield;
            int balls;
            final /* synthetic */ Location val$source;
            final /* synthetic */ ThreadLocalRandom val$random;
            final /* synthetic */ Location val$loc;
            final /* synthetic */ Player val$player;
            final /* synthetic */ ParticleDisplay val$display;
            final /* synthetic */ ParticleDisplay val$ex;
            {
                this.val$source = location;
                this.val$random = threadLocalRandom;
                this.val$loc = location2;
                this.val$player = player;
                this.val$display = particleDisplay;
                this.val$ex = particleDisplay2;
                this.yield = (float)FireMageMeteorite.this.getScaling(skilledPlayer, "yield", new Object[0]);
                this.balls = (int)FireMageMeteorite.this.getScaling(skilledPlayer, "fireballs", new Object[0]);
            }

            public void run() {
                Location location = this.val$source.clone().add(this.val$random.nextDouble(-3.0, 3.0), this.val$random.nextDouble(1.0, 15.0), this.val$random.nextDouble(-3.0, 3.0));
                Location location2 = this.val$loc.clone().add(this.val$random.nextDouble(-1.0, 1.0), 0.0, this.val$random.nextDouble(-1.0, 1.0));
                Vector vector = location2.toVector().subtract(location.toVector());
                final Fireball fireball = (Fireball)location.getWorld().spawnEntity(location, EntityType.FIREBALL);
                fireball.setDirection(vector.multiply(0.01));
                fireball.setYield(this.yield);
                fireball.setMetadata(FireMageMeteorite.METEORITE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)this.val$player));
                new BukkitRunnable(){

                    public void run() {
                        if (!fireball.isValid()) {
                            this.cancel();
                            return;
                        }
                        val$display.spawn(fireball.getLocation());
                        val$ex.spawn(fireball.getLocation());
                    }
                }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
                if (this.balls-- == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 5L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireBall(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)entityDamageByEntityEvent.getDamager();
        List list = fireball.getMetadata(METEORITE);
        if (list.isEmpty()) {
            return;
        }
        Player player = (Player)((MetadataValue)list.get(0)).value();
        if (player == entityDamageByEntityEvent.getEntity()) {
            entityDamageByEntityEvent.setCancelled(true);
        } else if (player == null || !ServiceHandler.canFight(entityDamageByEntityEvent.getEntity(), (Entity)player)) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onFireballLand(ProjectileHitEvent projectileHitEvent) {
        if (!(projectileHitEvent.getEntity() instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)projectileHitEvent.getEntity();
        if (!fireball.hasMetadata(METEORITE)) {
            return;
        }
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.LAVA).withLocation(fireball.getLocation()).withCount(50).offset(1.0, 1.0, 1.0);
        particleDisplay.spawn();
        Player player = (Player)((MetadataValue)fireball.getMetadata(METEORITE).get(0)).value();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        double d = this.getScaling(skilledPlayer, "damage", new Object[0]);
        double d2 = this.getScaling(skilledPlayer, "range", new Object[0]);
        for (Entity entity : fireball.getNearbyEntities(d2, d2, d2)) {
            if (EntityUtil.filterEntity(player, entity)) continue;
            DamageManager.damage((LivingEntity)entity, player, d);
        }
    }
}

