/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XBlock;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class FireMageInferno
extends ActiveAbility {
    private static final String NO_SPREAD = "NO_SPREAD";

    public FireMageInferno() {
        super("FireMage", "inferno");
    }

    private static void spreadFire(Location location, int n) {
        if (n == 0) {
            return;
        }
        Block block = location.getBlock().getRelative(BlockFace.DOWN);
        Material material = XMaterial.FIRE.parseMaterial();
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i = -n; i < n; ++i) {
            for (int j = -n; j < n; ++j) {
                Block block2 = block.getRelative(i, 0, j);
                if (!XBlock.isAir(block2.getType())) {
                    for (int k = -2; k < 4; ++k) {
                        Block block3 = block2.getRelative(0, k, 0);
                        if (!XBlock.isAir(block3.getType())) continue;
                        block2 = block3;
                        break;
                    }
                }
                if (!MathUtils.hasChance(70) || !XBlock.isAir(block2.getType())) continue;
                block2.setType(material);
                block2.setMetadata(NO_SPREAD, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
                arrayList.add(block2);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            for (Block block : arrayList) {
                block.removeMetadata(NO_SPREAD, (Plugin)SkillsPro.get());
                if (block.getType() != material) continue;
                block.setType(Material.AIR);
            }
        }, 200L);
    }

    @EventHandler
    public void spread(BlockSpreadEvent blockSpreadEvent) {
        Block block = blockSpreadEvent.getSource();
        if (block.hasMetadata(NO_SPREAD)) {
            blockSpreadEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        int n = skilledPlayer.getAbilityLevel(this);
        double d = this.getScaling(skilledPlayer, "damage", new Object[0]);
        double d2 = this.getScaling(skilledPlayer, "per-fire-tick", new Object[0]);
        double d3 = (double)entityDamageByEntityEvent.getEntity().getFireTicks() / d2;
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d3);
        player.getWorld().playEffect(entity.getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
        if (entity instanceof Player) {
            ((Player)entity).addPotionEffect(XPotion.NAUSEA.buildPotionEffect(160, 1));
        }
        XSound.BLOCK_LAVA_POP.play(entity);
        if (n > 1) {
            player.setFireTicks((int)((double)player.getFireTicks() + d * 20.0));
            FireMageInferno.spreadFire(player.getLocation(), (int)this.getScaling(skilledPlayer, "range", new Object[0]));
            if (n > 2) {
                Particles.helix((Plugin)SkillsPro.get(), n, 1.0, 0.1, 1.0, 3.0, 1.0, 0.5, false, true, ParticleDisplay.of(XParticle.FLAME).withLocation(entity.getLocation()));
            }
        }
    }
}

