/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.Particles;
import org.skills.utils.xseries.particles.XParticle;

public class FireMageAbsorbEnergy
extends Ability {
    public FireMageAbsorbEnergy() {
        super("FireMage", "absorb_energy");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFireMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = (int)this.getScaling(skilledPlayer, "chance", new Object[0]);
        if (!MathUtils.hasChance(n)) {
            return;
        }
        int n2 = skilledPlayer.getAbilityLevel(this);
        Entity entity = entityDamageByEntityEvent.getEntity();
        Location location = entity.getLocation();
        entity.setFireTicks((int)((double)entity.getFireTicks() + this.getScaling(skilledPlayer, "fire", entityDamageByEntityEvent) * 20.0));
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.FLAME).withLocation(location).withExtra(0.2);
        if (n2 == 1) {
            particleDisplay.withCount(n / 2).offset(0.5).spawn();
        } else {
            XSound.ITEM_FIRECHARGE_USE.play(entity);
            if (n2 == 2) {
                particleDisplay.withCount(n / 2 + 10).offset(0.3).spawn();
            } else {
                Particles.helix((Plugin)SkillsPro.get(), 3, 0.7, 0.1, 1.0, 5.0, 1.0, 0.5, false, false, ParticleDisplay.of(XParticle.FLAME).withLocation(location).withCount(2));
            }
        }
    }
}

