/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;

public class EidolonSpiritFire
extends Ability {
    private static final Map<UUID, Double> DAMAGE_ABSOPRTION = new HashMap<UUID, Double>();

    public EidolonSpiritFire() {
        super("Eidolon", "spirit_fire");
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getForm() != EidolonForm.DARK) {
            return;
        }
        Double d = DAMAGE_ABSOPRTION.remove(player.getUniqueId());
        if (d == null) {
            return;
        }
        double d2 = this.getScaling(skilledPlayer, "dark-damage-release", entityDamageByEntityEvent);
        double d3 = d / d2;
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d3);
        SkillsLang.Skill_Eidolon_Spirit_Expell.sendMessage(player, "%damage%", MathUtils.roundToDigits(d3, 2));
        DAMAGE_ABSOPRTION.remove(player.getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonDamageAbsorption(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getForm() != EidolonForm.LIGHT) {
            return;
        }
        double d = this.getScaling(skilledPlayer, "light-damage-absorption-percent", new Object[0]);
        double d2 = MathUtils.percentOfAmount(d, entityDamageByEntityEvent.getDamage());
        double d3 = this.getScaling(skilledPlayer, "max-damage-absorption", new Object[0]);
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() - d2);
        if (DAMAGE_ABSOPRTION.containsKey(player.getUniqueId())) {
            d2 = Math.max(d3, DAMAGE_ABSOPRTION.get(player.getUniqueId()) + d2);
        }
        DAMAGE_ABSOPRTION.put(player.getUniqueId(), d2);
    }
}

