/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.Cooldown;
import org.skills.utils.xseries.XPotion;

public class EidolonSpectre
extends Ability {
    public EidolonSpectre() {
        super("Eidolon", "spectre");
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getForm() != EidolonForm.DARK) {
            return;
        }
        if (Cooldown.isInCooldown(player.getUniqueId(), "EShield")) {
            return;
        }
        int n = (int)this.getScaling(skilledPlayer, "cooldown", new Object[0]);
        double d = this.getScaling(skilledPlayer, "dark-damage", new Object[0]);
        double d2 = 1.0 + d / 100.0;
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * d2);
        SkillsLang.Skill_Eidolon_Attack_Boost.sendMessage(player, "%damage%", d);
        new Cooldown(player.getUniqueId(), "EShield", n, TimeUnit.SECONDS);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getForm() != EidolonForm.LIGHT) {
            return;
        }
        if (Cooldown.isInCooldown(player.getUniqueId(), "EShield")) {
            return;
        }
        int n = (int)this.getScaling(skilledPlayer, "cooldown", new Object[0]);
        int n2 = (int)this.getScaling(skilledPlayer, "speed", new Object[0]);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 3) {
            n2 = 3;
        }
        player.addPotionEffect(XPotion.SPEED.buildPotionEffect(60, n2));
        SkillsLang.Skill_Eidolon_Shield_Speed.sendMessage(player, new Object[0]);
        new Cooldown(player.getUniqueId(), "EShield", n, TimeUnit.SECONDS);
    }
}

