/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.awt.Color;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.api.events.EidolonImbalanceChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class EidolonPassive
extends Ability {
    public EidolonPassive() {
        super("Eidolon", "passive");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEidolonChangeForm(EidolonImbalanceChangeEvent eidolonImbalanceChangeEvent) {
        Player player = eidolonImbalanceChangeEvent.getPlayer();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d = this.getScaling(skilledPlayer, "heal", new Object[0]);
        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> VersionSupport.heal((LivingEntity)eidolonImbalanceChangeEvent.getPlayer(), d));
        if (!skilledPlayer.showReadyMessage()) {
            return;
        }
        if (eidolonImbalanceChangeEvent.getNewForm() == EidolonForm.LIGHT) {
            ParticleDisplay.of(XParticle.DUST).withLocation(player.getLocation()).withColor(Color.WHITE, 1.0f).offset(0.5, 0.5, 0.5).withCount(100).spawn();
            this.playSound(player, skilledPlayer, "imbalance.light");
            SkillsLang.Skill_Eidolon_Turn_Light.sendMessage(player, new Object[0]);
        } else {
            ParticleDisplay.of(XParticle.DUST).withLocation(player.getLocation()).withColor(Color.BLACK, 1.0f).withCount(100).offset(0.5, 0.5, 0.5).spawn();
            this.playSound(player, skilledPlayer, "imbalance.dark");
            SkillsLang.Skill_Eidolon_Turn_Dark.sendMessage(player, new Object[0]);
        }
    }
}

