/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.DamageManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class EidolonFangs
extends InstantActiveAbility {
    private static final String FANGS = "EIDOLON_FANGS";

    public EidolonFangs() {
        super("Eidolon", "fangs");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        if (!XMaterial.supports(11)) {
            MessageHandler.sendPlayerPluginMessage(abilityContext.getPlayer(), "&cCannot use this ability in this version of Minecraft.");
            return;
        }
        Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        int n = (int)this.getScaling(skilledPlayer, "fangs", new Object[0]);
        EntityType entityType = XMaterial.supports(11) ? EntityType.EVOKER_FANGS : EntityType.FIREBALL;
        ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.DRAGON_BREATH).withCount(20).offset(1.0);
        if (player.isSneaking()) {
            for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!(entity instanceof LivingEntity) || !entity.isValid() || entity.getType() == EntityType.ARMOR_STAND) continue;
                Location location = entity.getLocation();
                Entity entity2 = player.getWorld().spawnEntity(location, entityType);
                entity2.setMetadata(FANGS, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
                if (entityType != EntityType.FIREBALL) {
                    EvokerFangs evokerFangs = (EvokerFangs)entity2;
                    evokerFangs.setOwner((LivingEntity)player);
                }
                particleDisplay.spawn(location);
            }
            return;
        }
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, n);
        boolean bl = XMaterial.supports(13);
        while (blockIterator.hasNext()) {
            Block block;
            Block block2 = (Block)blockIterator.next();
            Block block3 = null;
            if (block2.getRelative(BlockFace.DOWN).getType().isSolid()) {
                block3 = block2;
            } else {
                boolean bl2;
                int n2;
                for (n2 = 0; n2 > -5; --n2) {
                    block = block2.getRelative(0, n2, 0);
                    bl2 = block.getRelative(BlockFace.DOWN).getType().isSolid();
                    if (bl) {
                        if (block.isPassable() && bl2) {
                            block3 = block;
                            break;
                        }
                    } else if (!block.getType().isSolid() && bl2) {
                        block3 = block;
                        break;
                    }
                    if (bl2) break;
                }
                if (block3 == null) {
                    for (n2 = 0; n2 < 5; ++n2) {
                        block = block2.getRelative(0, n2, 0);
                        bl2 = block.getRelative(BlockFace.DOWN).getType().isSolid();
                        if (bl) {
                            if (!block.isPassable() || !bl2) continue;
                            block3 = block;
                            break;
                        }
                        if (block.getType().isSolid() || !bl2) continue;
                        block3 = block;
                        break;
                    }
                }
            }
            if (block3 == null) {
                block3 = player.getLocation().getBlock();
            }
            Location location = block3.getLocation();
            block = player.getWorld().spawnEntity(location, entityType);
            block.setMetadata(FANGS, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
            if (entityType != EntityType.FIREBALL) {
                EvokerFangs evokerFangs = (EvokerFangs)block;
                evokerFangs.setOwner((LivingEntity)player);
            }
            particleDisplay.spawn(location);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFangsBite(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!XMaterial.supports(11)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity.getType() != EntityType.EVOKER_FANGS) {
            return;
        }
        if (!entity.hasMetadata(FANGS)) {
            return;
        }
        EvokerFangs evokerFangs = (EvokerFangs)entity;
        entityDamageByEntityEvent.setCancelled(true);
        if (!ServiceHandler.canFight((Entity)evokerFangs.getOwner(), entityDamageByEntityEvent.getEntity())) {
            return;
        }
        Player player = (Player)evokerFangs.getOwner();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        ParticleDisplay particleDisplay = ParticleDisplay.colored(entity.getLocation(), 255, 0, 0, 1.0f);
        particleDisplay.spawn();
        DamageManager.damage((LivingEntity)entityDamageByEntityEvent.getEntity(), player, this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent));
    }
}

