/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.DamageManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.EntityUtil;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class EidolonBlackhole
extends InstantActiveAbility {
    private static final String BLACKHOLE = "BLACKHOLE";

    public EidolonBlackhole() {
        super("Eidolon", "blackhole");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        final Player player = abilityContext.getPlayer();
        final SkilledPlayer skilledPlayer = abilityContext.getInfo();
        final Location location = player.getEyeLocation();
        final ParticleDisplay particleDisplay = ParticleDisplay.of(XParticle.PORTAL).withLocation(location).withCount(100).withExtra(3.0);
        final ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(location.clone().add(0.0, -1.5, 0.0), EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setMarker(true);
        armorStand.getEquipment().setHelmet(XMaterial.DRAGON_EGG.parseItem());
        EidolonBlackhole.addEntity((Entity)armorStand);
        this.playSound(player, skilledPlayer, "start");
        final long l = (long)this.getScaling(skilledPlayer, "quality", new Object[0]);
        new BukkitRunnable(){
            final double range;
            final double gravity;
            final double distance;
            final double damage;
            final World world;
            final Set<EntityType> blacklisted;
            long duration;
            int repeat;
            double rotation;
            {
                this.range = EidolonBlackhole.this.getScaling(skilledPlayer, "range", new Object[0]);
                this.gravity = EidolonBlackhole.this.getScaling(skilledPlayer, "gravity", new Object[0]);
                this.distance = EidolonBlackhole.this.getScaling(skilledPlayer, "distance", new Object[0]);
                this.damage = EidolonBlackhole.this.getScaling(skilledPlayer, "damage", new Object[0]);
                this.world = location.getWorld();
                this.blacklisted = EidolonBlackhole.this.getEntityList(skilledPlayer, "blacklisted");
                this.duration = (long)EidolonBlackhole.this.getScaling(skilledPlayer, "duration", new Object[0]);
                this.repeat = 0;
                this.rotation = 0.0;
            }

            public void run() {
                for (Entity entity : this.world.getNearbyEntities(location, this.range, this.range, this.range)) {
                    if (player == entity) continue;
                    if (!this.blacklisted.contains(entity.getType())) {
                        Vector vector = location.toVector().subtract(entity.getLocation().toVector()).normalize();
                        entity.setVelocity(vector.multiply(this.gravity));
                        continue;
                    }
                    if (EntityUtil.filterEntity(player, entity) || !(entity.getLocation().distance(location) < this.distance)) continue;
                    DamageManager.damage((LivingEntity)entity, player, this.damage);
                    if (!(entity instanceof Player)) continue;
                    EidolonBlackhole.this.applyEffects(skilledPlayer, (LivingEntity)entity);
                }
                particleDisplay.spawn();
                armorStand.setHeadPose(new EulerAngle(this.rotation, this.rotation * -1.0, 0.0));
                this.rotation += 0.1;
                if (this.rotation > 360.0) {
                    this.rotation = 0.0;
                }
                this.repeat = (int)((long)this.repeat + l);
                if (this.repeat >= 20) {
                    this.repeat = 0;
                    EidolonBlackhole.this.playSound(player, skilledPlayer, "blackhole");
                }
                this.duration -= l;
                if (this.duration <= 0L) {
                    this.cancel();
                    armorStand.remove();
                    Ability.removeEntity((Entity)armorStand);
                    TNTPrimed tNTPrimed = (TNTPrimed)location.getWorld().spawnEntity(location, XEntityType.TNT.get());
                    tNTPrimed.setMetadata(EidolonBlackhole.BLACKHOLE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player));
                    tNTPrimed.setYield((float)EidolonBlackhole.this.getScaling(skilledPlayer, "yield", new Object[0]));
                    tNTPrimed.setFuseTicks(0);
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, l);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void tntDmaage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof TNTPrimed)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        List list = entity.getMetadata(BLACKHOLE);
        if (list.isEmpty()) {
            return;
        }
        Player player = (Player)((MetadataValue)entity.getMetadata(BLACKHOLE).get(0)).value();
        if (player != null && ServiceHandler.areFriendly(entityDamageByEntityEvent.getEntity(), (Entity)player)) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }
}

