/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.Cooldown;
import org.skills.utils.LocationUtils;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class DevourerHook
extends InstantActiveAbility {
    private static final String COOLDOWN = "DEVOURER_HOOK";
    private static final Map<Integer, Player> HOOKS = new HashMap<Integer, Player>();
    private static final Set<Integer> HOOKED = new HashSet<Integer>();

    public DevourerHook() {
        super("Devourer", "hook");
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        Entity entity = player.getWorld().spawnEntity(player.getEyeLocation(), (EntityType)Enums.getIfPresent(EntityType.class, (String)this.getOptions(skilledPlayer, "hook").getString()).orNull());
        entity.setVelocity(player.getLocation().getDirection().multiply(skilledPlayer.getAbilityLevel(this) + 1));
        HOOKS.put(entity.getEntityId(), player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && HOOKED.remove(entityDamageEvent.getEntity().getEntityId())) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void hookDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (HOOKED.remove(entityDamageByEntityEvent.getDamager().getEntityId())) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSprint(PlayerMoveEvent playerMoveEvent) {
        if (MathUtils.isInteger(playerMoveEvent.getTo().getY())) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SkillsPro.get(), () -> {
                if (Cooldown.isInCooldown(playerMoveEvent.getPlayer().getUniqueId(), COOLDOWN)) {
                    return;
                }
                HOOKED.remove(playerMoveEvent.getPlayer().getEntityId());
            }, 2L);
        }
    }

    @EventHandler
    public void onHooked(ProjectileHitEvent projectileHitEvent) {
        Location location;
        Projectile projectile = projectileHitEvent.getEntity();
        final Player player = HOOKS.remove(projectile.getEntityId());
        if (player == null) {
            return;
        }
        if (projectileHitEvent.getHitEntity() != null) {
            HOOKED.add(projectile.getEntityId());
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        Location location2 = player.getLocation();
        if (location2.distance(location = projectile.getLocation()) > this.getScaling(skilledPlayer, "range", new Object[0])) {
            return;
        }
        Block block = projectileHitEvent.getHitBlock();
        if (block != null) {
            XMaterial xMaterial = XMaterial.matchXMaterial(block.getType());
            List<String> list = this.getOptions(skilledPlayer, "untargetable-blocks").getStringList();
            if (list.contains(xMaterial.name())) {
                return;
            }
        }
        LocationUtils.whoooosh((Entity)player, location, 0.15, 0.05, 0.15);
        ParticleDisplay.of(XParticle.CLOUD).withLocation(location2).withCount(50).offset(1.0, 0.0, 1.0).spawn();
        try {
            XSound.ENTITY_FISHING_BOBBER_RETRIEVE.play((Entity)player);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (skilledPlayer.getAbilityLevel(this) > 1) {
            HOOKED.add(player.getEntityId());
            new Cooldown(player.getUniqueId(), COOLDOWN, 2L, TimeUnit.SECONDS);
        }
        new BukkitRunnable(){
            final ParticleDisplay dis = ParticleDisplay.of(XParticle.LARGE_SMOKE).withLocation(null);
            int times = 0;

            public void run() {
                ++this.times;
                this.dis.spawn(player.getLocation());
                if (this.times > 20) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
    }

    static {
        DevourerHook.addDisposableHandler(HOOKED);
        DevourerHook.addDisposableHandler(HOOKS);
    }
}

