/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.utils.Cooldown;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class DevourerBlink
extends ActiveAbility {
    private static final Map<UUID, Integer> HITS = new HashMap<UUID, Integer>();

    public DevourerBlink() {
        super("Devourer", "blink");
    }

    private static boolean safeTp(Entity entity, Location location) {
        if (XMaterial.supports(13)) {
            if (location.getBlock().isPassable() && location.getBlock().getRelative(BlockFace.UP).isPassable()) {
                entity.teleport(location);
                return true;
            }
        } else if (!location.getBlock().getType().isSolid() && !location.getBlock().getRelative(BlockFace.UP).getType().isSolid()) {
            entity.teleport(location);
            return true;
        }
        return false;
    }

    private static Location getBack(Location location) {
        float f = location.getYaw() + 90.0f;
        if (f < 0.0f) {
            f += 360.0f;
        }
        double d = Math.cos(Math.toRadians(f));
        double d2 = Math.sin(Math.toRadians(f));
        return new Location(location.getWorld(), location.getX() - d, location.getY(), location.getZ() - d2, location.getYaw(), location.getPitch());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDevourerAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.commonDamageCheckup(entityDamageByEntityEvent)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        int n = HITS.getOrDefault(player.getUniqueId(), 0);
        if (n == -1 || n != 0 && !Cooldown.isInCooldown(player.getUniqueId(), "BLINK")) {
            HITS.remove(player.getUniqueId());
            return;
        }
        SkilledPlayer skilledPlayer = n == 0 ? this.checkup(player) : SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer == null) {
            return;
        }
        ++n;
        int n2 = skilledPlayer.getAbilityLevel(this);
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        ParticleDisplay.of(XParticle.CLOUD).withLocation(player.getLocation()).offset(1.0).withCount(100).spawn();
        player.addPotionEffect(XPotion.SPEED.getPotionEffectType().createEffect(200, 1));
        XSound.ENTITY_ENDERMAN_TELEPORT.play((Entity)player);
        int n3 = (int)this.getScaling(skilledPlayer, "hits", new Object[0]);
        if (n2 == 1) {
            DevourerBlink.safeTp((Entity)player, DevourerBlink.getBack(livingEntity.getEyeLocation()));
            if (n > n3) {
                n = -1;
            }
        } else if (n2 == 2) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            double d = 2.0 * Math.cos(threadLocalRandom.nextDouble(0.0, Math.PI * 2));
            double d2 = 2.0 * Math.sin(threadLocalRandom.nextDouble(0.0, Math.PI * 2));
            Location location = livingEntity.getEyeLocation().clone().add(d, 0.0, d2);
            location.setDirection(livingEntity.getEyeLocation().toVector().subtract(location.toVector()));
            DevourerBlink.safeTp((Entity)player, location);
            if (n > n3) {
                n = -1;
            }
        } else {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            double d = threadLocalRandom.nextDouble(0.0, 3.0);
            double d3 = d * Math.cos(threadLocalRandom.nextDouble(0.0, Math.PI * 2));
            double d4 = threadLocalRandom.nextDouble(0.5, 2.0);
            double d5 = d * Math.sin(threadLocalRandom.nextDouble(0.0, Math.PI * 2));
            Location location = livingEntity.getEyeLocation().clone().add(d3, d4, d5);
            location.setDirection(livingEntity.getEyeLocation().toVector().subtract(location.toVector()));
            DevourerBlink.safeTp((Entity)player, location);
            if (n > n3) {
                n = -1;
            }
        }
        if (n != -1) {
            new Cooldown(player.getUniqueId(), "BLINK", 2000L + (long)n2 * 500L, TimeUnit.MILLISECONDS);
        }
        HITS.put(player.getUniqueId(), n);
    }
}

