/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.XParticle;

public class ArbalistPassive
extends Ability {
    public static final String ARBALIST_ARROW = "ARBALIST";

    public ArbalistPassive() {
        super("Arbalist", "passive");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entityDamageByEntityEvent.getDamager();
        if (arrow.getShooter() == null || !(arrow.getShooter() instanceof Player)) {
            return;
        }
        if (arrow.hasMetadata(ARBALIST_ARROW)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        Player player = (Player)arrow.getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d = player.getLocation().distance(entityDamageByEntityEvent.getEntity().getLocation());
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d / 5.0);
        World world = entity.getWorld();
        if (!MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", new Object[0]))) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            Location location = entity.getLocation().add(0.0, 10.0, 0.0);
            world.spawnParticle(XParticle.CLOUD.get(), location, 200, 1.0, 0.0, 1.0, 0.0);
            int n = 0;
            while ((double)n < this.getScaling(skilledPlayer, "arrows", new Object[0])) {
                int n2 = MathUtils.randInt(0, n);
                int n3 = MathUtils.randInt(0, n);
                Location location2 = location.clone().add((double)n2, 0.0, (double)n3);
                Location location3 = entity.getLocation().add((double)n2, 0.0, (double)n3);
                Vector vector = location3.toVector().subtract(location2.toVector());
                Arrow arrow = (Arrow)world.spawnEntity(location2, EntityType.ARROW);
                arrow.setShooter((ProjectileSource)player);
                arrow.setMetadata(ARBALIST_ARROW, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
                if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "flame-chance", new Object[0]))) {
                    arrow.setFireTicks(200);
                }
                arrow.setVelocity(vector.multiply(0.1));
                if (XMaterial.supports(14)) {
                    arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                }
                ++n;
            }
        }, 10L);
    }
}

