/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.InstantActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XEntityType;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.XParticle;

public class ArbalistFireCrossbow
extends InstantActiveAbility {
    public static final String ARBALIST_FIRECROSSBOW = "ARBALIST_CROSS";

    public ArbalistFireCrossbow() {
        super("Arbalist", "fire_crossbow");
        if (!XMaterial.supports(14)) {
            Bukkit.getPluginManager().registerEvents((Listener)new Old(), (Plugin)SkillsPro.get());
        }
    }

    @Override
    public void useSkill(AbilityContext abilityContext) {
        int n;
        final Player player = abilityContext.getPlayer();
        SkilledPlayer skilledPlayer = abilityContext.getInfo();
        Vector vector = player.getEyeLocation().getDirection();
        final double d = this.getScaling(skilledPlayer, "range", new Object[0]);
        int n2 = (int)this.getScaling(skilledPlayer, "knockback", new Object[0]);
        int n3 = (int)this.getScaling(skilledPlayer, "fire", new Object[0]);
        vector.multiply(d);
        final Arrow arrow = (Arrow)player.launchProjectile(Arrow.class, vector);
        arrow.setInvulnerable(true);
        arrow.setBounce(false);
        arrow.setFireTicks(n3);
        arrow.setKnockbackStrength(n2);
        arrow.setMetadata(ARBALIST_FIRECROSSBOW, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
        if (XMaterial.supports(14)) {
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        if (MathUtils.hasChance(n = (int)this.getScaling(skilledPlayer, "shotgun.chance", new Object[0]))) {
            int n4 = (int)this.getScaling(skilledPlayer, "shotgun.amount.min", new Object[0]);
            int n5 = (int)this.getScaling(skilledPlayer, "shotgun.amount.max", new Object[0]);
            double d2 = (int)this.getScaling(skilledPlayer, "shotgun.offset", new Object[0]);
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            for (int i = 0; i < threadLocalRandom.nextInt(n4, n5); ++i) {
                Arrow arrow2 = player.getWorld().spawnArrow(player.getEyeLocation(), vector, (float)d, (float)d2);
                arrow2.setMetadata(ARBALIST_FIRECROSSBOW, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
                if (!XMaterial.supports(14)) continue;
                arrow2.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
        }
        arrow.setGlowing(true);
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "critical-chance", new Object[0]))) {
            arrow.setCritical(true);
        }
        XSound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR.play((Entity)player);
        player.spawnParticle(XParticle.LAVA.get(), player.getLocation(), (int)(d * 2.0) + 10, 0.1, 0.1, 0.1, 1.0);
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                ++this.i;
                if (this.i > 4) {
                    this.cancel();
                }
                if (arrow.isOnGround()) {
                    this.cancel();
                }
                if (XMaterial.supports(13)) {
                    player.playNote(arrow.getLocation(), Instrument.CHIME, Note.natural((int)1, (Note.Tone)Note.Tone.values()[this.i]));
                }
                player.spawnParticle(XParticle.FLAME.get(), arrow.getLocation(), (int)(d * 2.0), 0.01, 0.01, 0.01, 0.1);
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 5L, 5L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onTargetHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Projectile)) {
            return;
        }
        if (!entity.hasMetadata(ARBALIST_FIRECROSSBOW)) {
            return;
        }
        Player player = (Player)((Projectile)entity).getShooter();
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        entityDamageByEntityEvent.setDamage((double)((int)this.getScaling(skilledPlayer, "damage", new Object[0])));
        XSound.ENTITY_EXPERIENCE_ORB_PICKUP.play((Entity)player, 2.0f, 0.0f);
        player.spawnParticle(XParticle.LAVA.get(), entityDamageByEntityEvent.getEntity().getLocation(), 30, 0.1, 0.1, 0.1, 0.1);
    }

    @EventHandler
    public void onBlockHit(ProjectileHitEvent projectileHitEvent) {
        Projectile projectile = projectileHitEvent.getEntity();
        if (projectileHitEvent.getHitBlock() == null) {
            return;
        }
        if (!projectile.hasMetadata(ARBALIST_FIRECROSSBOW)) {
            return;
        }
        projectile.removeMetadata(ARBALIST_FIRECROSSBOW, (Plugin)SkillsPro.get());
        Player player = (Player)projectile.getShooter();
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "explosion-chance", new Object[0]))) {
            TNTPrimed tNTPrimed = (TNTPrimed)player.getLocation().getWorld().spawnEntity(projectileHitEvent.getHitBlock().getLocation(), XEntityType.TNT.get());
            tNTPrimed.setFuseTicks(1);
        }
    }

    private static class Old
    implements Listener {
        private Old() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerPickupItem(PlayerPickupArrowEvent playerPickupArrowEvent) {
            if (playerPickupArrowEvent.getItem().hasMetadata("ARBALIST")) {
                playerPickupArrowEvent.setCancelled(true);
            }
        }
    }
}

