/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class ArbalistExecute
extends Ability {
    private static final Map<UUID, UUID> EXECUTOR = new HashMap<UUID, UUID>();
    private static final Map<UUID, Integer> EXECUTES = new HashMap<UUID, Integer>();

    public ArbalistExecute() {
        super("Arbalist", "execute");
    }

    @EventHandler
    public void onMiss(ProjectileHitEvent projectileHitEvent) {
        if (projectileHitEvent.getHitEntity() != null) {
            return;
        }
        if (!(projectileHitEvent.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)projectileHitEvent.getEntity();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)arrow.getShooter();
        UUID uUID = EXECUTOR.remove(player.getUniqueId());
        if (uUID != null) {
            EXECUTES.remove(uUID);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entityDamageByEntityEvent.getDamager();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)arrow.getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        UUID uUID = EXECUTOR.get(player.getUniqueId());
        if (!entity.getUniqueId().equals(uUID)) {
            EXECUTOR.put(player.getUniqueId(), entity.getUniqueId());
            EXECUTES.put(uUID, 1);
            return;
        }
        int n = EXECUTES.getOrDefault(uUID, 0);
        EXECUTES.put(uUID, n + 1);
        int n2 = skilledPlayer.getAbilityLevel(this);
        int n3 = (int)this.getScaling(skilledPlayer, "chance", new Object[0]);
        int n4 = n * 2;
        if (MathUtils.hasChance(n3 + n4)) {
            this.applyEffects(skilledPlayer, (LivingEntity)entity);
        }
        if (n2 > 1 && MathUtils.hasChance(n3 - 10 + n4)) {
            entity.setFireTicks(entity.getFireTicks() + 100);
        }
        if (n2 > 2 && MathUtils.hasChance(n3 - 15 + n4)) {
            entity.getWorld().strikeLightning(entity.getLocation());
        }
        if (XMaterial.supports(13)) {
            player.playNote(player.getLocation(), Instrument.CHIME, Note.natural((int)0, (Note.Tone)Note.Tone.values()[Math.min(n, Note.Tone.values().length - 1)]));
        }
        ParticleDisplay.of(XParticle.CRIT).withLocation(entity.getLocation()).withCount(10).spawn();
    }
}

